/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.fileAssociationsWindows;

import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.common.io.FileExtensionsKt;
import com.jetbrains.toolbox.fileAssociationsWindows.CheckResult;
import com.jetbrains.toolbox.fileAssociationsWindows.OpenableAppRegistration;
import com.jetbrains.toolbox.fileAssociationsWindows.WindowsAssociations;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class WindowsFileAssociationsUpdaterKt {
    private static final Path calculateExePath(Path command2, Path installDir) {
        Object object;
        ThreadGuardKt.assertNotMainThread("java.io.File.listFiles()");
        Path path2 = command2;
        return path2 != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (File)FileExtensionsKt.getPathUnderRootDirectory(path2.toFile(), ""), (boolean)false, (int)1, null) : ((object = installDir.toFile().listFiles(WindowsFileAssociationsUpdaterKt::calculateExePath$lambda$0)) != null && (object = (File)ArraysKt.singleOrNull((Object[])object)) != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (File)object, (boolean)false, (int)1, null) : null);
    }

    /*
     * Unable to fully structure code
     */
    private static final void registerAppAndAssociations(WindowsAssociations $this$registerAppAndAssociations, boolean createFileAssociationsFromSettings, String progId, Path command, Path installDir, Boolean existingAddToOpenWith, Set<String> existingFileExtensions, List<String> argsForOpenWith, String friendlyAppName, Function0<? extends Set<String>> extensionsFromFeed, Function0<Boolean> addToOpenWithFromFeed) {
        if (!createFileAssociationsFromSettings) ** GOTO lbl-1000
        v0 = existingAddToOpenWith;
        if (v0 != null ? v0.booleanValue() : ((Boolean)addToOpenWithFromFeed.invoke()).booleanValue()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = addToOpenWith = false;
        }
        if (!addToOpenWith) {
            Logger.INSTANCE.info("App (" + installDir + ") and its supported file extensions aren't registered because this app shouldn't open files (settings: " + createFileAssociationsFromSettings + ", from feed: " + (existingAddToOpenWith == null) + ")");
            return;
        }
        exePath = WindowsFileAssociationsUpdaterKt.calculateExePath(command, installDir);
        if (exePath == null) {
            Logger.INSTANCE.warn("Can't calculate exe path for '" + installDir + "', skipping registering app and associations");
            return;
        }
        $this$registerAppAndAssociations.registerOpenableApp(progId, exePath, argsForOpenWith, friendlyAppName);
        v2 = existingFileExtensions;
        if (v2 == null) {
            v2 = (Set)extensionsFromFeed.invoke();
        }
        fileExtensions = v2;
        for (String extensionWithoutDot : fileExtensions) {
            $this$registerAppAndAssociations.addAppToExtensionHandlers(progId, extensionWithoutDot);
        }
        $this$registerAppAndAssociations.notifyShellAboutChangedAssociations();
        Logger.INSTANCE.info("App (" + installDir + ") and " + fileExtensions.size() + " file association(s) (from feed: " + (existingFileExtensions == null) + ") are registered");
    }

    /*
     * Unable to fully structure code
     */
    private static final CheckResult checkRegistrationOfAppAndAssociations(WindowsAssociations $this$checkRegistrationOfAppAndAssociations, boolean createFileAssociationsFromSettings, String progId, Path command, Path installDir, Boolean existingAddToOpenWith, Set<String> existingFileExtensions, List<String> argsForOpenWith, String friendlyAppName, Function0<? extends Set<String>> extensionsFromFeed, Function0<Boolean> addToOpenWithFromFeed) {
        exePath = WindowsFileAssociationsUpdaterKt.calculateExePath(command, installDir);
        if (exePath == null) {
            Logger.INSTANCE.warn("Can't calculate exe path for '" + installDir + "' (+ '" + command + "'), considering check not passed");
            return CheckResult.CANNOT_CHECK;
        }
        if (!createFileAssociationsFromSettings) ** GOTO lbl-1000
        v0 = existingAddToOpenWith;
        if (v0 != null ? v0.booleanValue() : ((Boolean)addToOpenWithFromFeed.invoke()).booleanValue()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        addToOpenWith = v1;
        expectedRegistration = addToOpenWith != false ? OpenableAppRegistration.FULL : OpenableAppRegistration.NOT_REGISTERED_AT_ALL;
        v2 = failureResult = addToOpenWith != false ? CheckResult.REGISTRATION_NEEDED : CheckResult.DEREGISTRATION_NEEDED;
        if ($this$checkRegistrationOfAppAndAssociations.checkOpenableApp(progId, exePath, argsForOpenWith, friendlyAppName) != expectedRegistration) {
            return failureResult;
        }
        v3 = existingFileExtensions;
        if (v3 == null) {
            v3 = (Set)extensionsFromFeed.invoke();
        }
        for (String extensionWithoutDot : v3) {
            if ($this$checkRegistrationOfAppAndAssociations.checkExtensionHandler(progId, extensionWithoutDot) == addToOpenWith) continue;
            return failureResult;
        }
        return CheckResult.OK;
    }

    public static final void deregisterAppAndAssociations(@NotNull WindowsAssociations $this$deregisterAppAndAssociations, @NotNull String progId, @NotNull Path installDirForLogging, @Nullable Set<String> existingFileExtensions, @NotNull Function0<? extends Set<String>> extensionsFromFeed) {
        Intrinsics.checkNotNullParameter((Object)$this$deregisterAppAndAssociations, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)progId, (String)"progId");
        Intrinsics.checkNotNullParameter((Object)installDirForLogging, (String)"installDirForLogging");
        Intrinsics.checkNotNullParameter(extensionsFromFeed, (String)"extensionsFromFeed");
        $this$deregisterAppAndAssociations.deregisterOpenableApp(progId);
        Set set = existingFileExtensions;
        if (set == null) {
            set = (Set)extensionsFromFeed.invoke();
        }
        Set fileExtensions = set;
        for (String extensionWithoutDot : fileExtensions) {
            $this$deregisterAppAndAssociations.removeAppFromExtensionHandlers(progId, extensionWithoutDot);
        }
        $this$deregisterAppAndAssociations.notifyShellAboutChangedAssociations();
        Logger.INSTANCE.info("App (" + installDirForLogging + ") and " + fileExtensions.size() + " file association(s) (from feed: " + (existingFileExtensions == null) + ") are deregistered");
    }

    public static final void ensureAppAndAssociationsRegistered(@NotNull WindowsAssociations $this$ensureAppAndAssociationsRegistered, boolean createFileAssociationsFromSettings, @NotNull String progId, @Nullable Path command2, @NotNull Path installDir, @Nullable Boolean existingAddToOpenWith, @Nullable Set<String> existingFileExtensions, @Nullable List<String> argsForOpenWith, @NotNull String friendlyAppName, @NotNull Function0<? extends Set<String>> extensionsFromFeed, @NotNull Function0<Boolean> addToOpenWithFromFeed) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureAppAndAssociationsRegistered, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)progId, (String)"progId");
        Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
        Intrinsics.checkNotNullParameter((Object)friendlyAppName, (String)"friendlyAppName");
        Intrinsics.checkNotNullParameter(extensionsFromFeed, (String)"extensionsFromFeed");
        Intrinsics.checkNotNullParameter(addToOpenWithFromFeed, (String)"addToOpenWithFromFeed");
        CheckResult checkResult = WindowsFileAssociationsUpdaterKt.checkRegistrationOfAppAndAssociations($this$ensureAppAndAssociationsRegistered, createFileAssociationsFromSettings, progId, command2, installDir, existingAddToOpenWith, existingFileExtensions, argsForOpenWith, friendlyAppName, extensionsFromFeed, addToOpenWithFromFeed);
        if (checkResult == CheckResult.REGISTRATION_NEEDED) {
            Logger.INSTANCE.info("While ensuring for '" + installDir + "': looks like file associations aren't up-to-date, registering...");
            WindowsFileAssociationsUpdaterKt.registerAppAndAssociations($this$ensureAppAndAssociationsRegistered, createFileAssociationsFromSettings, progId, command2, installDir, existingAddToOpenWith, existingFileExtensions, argsForOpenWith, friendlyAppName, extensionsFromFeed, addToOpenWithFromFeed);
        } else if (checkResult == CheckResult.DEREGISTRATION_NEEDED) {
            Logger.INSTANCE.info("While ensuring for '" + installDir + "': looks like there are redundant file associations and/or Open With entries, deregistering...");
            WindowsFileAssociationsUpdaterKt.deregisterAppAndAssociations($this$ensureAppAndAssociationsRegistered, progId, installDir, existingFileExtensions, extensionsFromFeed);
        }
    }

    private static final boolean calculateExePath$lambda$0(File f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        String string = f.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string, (String)".exe", (boolean)false, (int)2, null);
    }
}

