/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.feed.FeedV1SafeJsonKt;
import com.jetbrains.toolbox.feed.JsonHelpersKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SafeSerializerWrapper<T>
implements KSerializer<T> {
    @NotNull
    private final KSerializer<T> innerSerializer;

    public SafeSerializerWrapper(@NotNull KSerializer<T> innerSerializer) {
        Intrinsics.checkNotNullParameter(innerSerializer, (String)"innerSerializer");
        this.innerSerializer = innerSerializer;
    }

    @Nullable
    public T deserialize(@NotNull Decoder decoder) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        try {
            Object object2;
            if (decoder instanceof JsonDecoder) {
                JsonElement obj = ((JsonDecoder)decoder).decodeJsonElement();
                if (!(obj instanceof JsonObject)) {
                    FeedV1SafeJsonKt.access$getLogger$p().warn("Failed to parse feed item of type " + this.innerSerializer.getDescriptor().getSerialName() + ". Expected object, got " + obj + " instead");
                    return null;
                }
                object2 = JsonHelpersKt.getJson().decodeFromJsonElement((DeserializationStrategy)this.innerSerializer, obj);
            } else {
                object2 = this.innerSerializer.deserialize(decoder);
            }
            object = object2;
        }
        catch (Exception ex) {
            FeedV1SafeJsonKt.access$getLogger$p().warn("Failed to parse feed item of type " + this.innerSerializer.getDescriptor().getSerialName(), (Throwable)ex);
            return null;
        }
        return (T)object;
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.innerSerializer.getDescriptor();
    }

    public void serialize(@NotNull Encoder encoder, @Nullable T value2) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        if (value2 == null) {
            throw new IllegalStateException("Can't serialize null values".toString());
        }
        this.innerSerializer.serialize(encoder, value2);
    }
}

