/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.accounts.AccountManager;
import com.jetbrains.toolbox.accounts.AccountManagerKt;
import com.jetbrains.toolbox.accounts.JetBrainsAccount;
import com.jetbrains.toolbox.feed.FeedLocation;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SelfSettingsKt;
import com.jetbrains.toolbox.settings.SettingsManager;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class InternalFeedProvider {
    @NotNull
    private final AccountManager accountManager;
    @NotNull
    private final SettingsManager settingsManager;

    public InternalFeedProvider(@NotNull AccountManager accountManager, @NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)accountManager, (String)"accountManager");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        this.accountManager = accountManager;
        this.settingsManager = settingsManager;
    }

    @NotNull
    public final List<FeedLocation> getInternalFeedLocations() {
        List list2;
        JetBrainsAccount jetBrainsAccount2 = (JetBrainsAccount)AccountManagerKt.getJba(this.accountManager).getActiveAccount().getValue();
        if (!(jetBrainsAccount2 != null ? jetBrainsAccount2.isInternal() : false)) {
            return CollectionsKt.emptyList();
        }
        String domain = SelfSettingsKt.getUseStaging(((SelfSettings)this.settingsManager.getSettings().getValue()).getInternal()) ? "staging.toolbox.app" : "feed.toolbox.app";
        FeedLocation secureFeedUrl = new FeedLocation("https://secure." + domain + "/feeds/v1/secure-feed.feed.xz.signed", null, false, 6, null);
        FeedLocation secureArmFeedUrl = new FeedLocation("https://secure." + domain + "/feeds/v1/nightly-arm.feed.xz.signed", null, false, 6, null);
        List $this$getInternalFeedLocations_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getInternalFeedLocations_u24lambda_u240.add(secureFeedUrl);
        if (OS.INSTANCE.isMacArm()) {
            $this$getInternalFeedLocations_u24lambda_u240.add(secureArmFeedUrl);
        }
        return CollectionsKt.build((List)list2);
    }
}

