/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feed;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.ModelUpdateReason;
import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.accounts.AccountManager;
import com.jetbrains.toolbox.accounts.AccountManagerKt;
import com.jetbrains.toolbox.accounts.JetBrainsAccount;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.feed.FeedLocation;
import com.jetbrains.toolbox.feed.LinkUpdater;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SelfSettingsKt;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.settings.Storage;
import com.jetbrains.toolbox.settings.StorageManager;
import com.jetbrains.toolbox.util.IsAutomatedTestKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nFeedLocationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeedLocationProvider.kt\ncom/jetbrains/toolbox/feed/FeedLocationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1#2:78\n1563#3:79\n1634#3,3:80\n*S KotlinDebug\n*F\n+ 1 FeedLocationProvider.kt\ncom/jetbrains/toolbox/feed/FeedLocationProvider\n*L\n42#1:79\n42#1:80,3\n*E\n"})
public final class FeedLocationProvider {
    @NotNull
    private final String userId;
    @NotNull
    private final String machineId;
    @NotNull
    private final AccountManager accountManager;
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final LinkUpdater linkUpdater;

    public FeedLocationProvider(@NotNull String userId, @NotNull String machineId, @NotNull AccountManager accountManager, @NotNull SettingsManager settingsManager, @NotNull StorageManager storageManager, @NotNull LinkUpdater linkUpdater) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)machineId, (String)"machineId");
        Intrinsics.checkNotNullParameter((Object)accountManager, (String)"accountManager");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)linkUpdater, (String)"linkUpdater");
        this.userId = userId;
        this.machineId = machineId;
        this.accountManager = accountManager;
        this.settingsManager = settingsManager;
        this.storageManager = storageManager;
        this.linkUpdater = linkUpdater;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<FeedLocation> feeds(@Nullable ModelUpdateReason reason) {
        block6: {
            block5: {
                if (!IsAutomatedTestKt.isAutomatedTest()) break block5;
                v0 = "automated";
                break block6;
            }
            if (((SelfSettings)this.settingsManager.getSettings().getValue()).getInternal().getEnabled()) ** GOTO lbl-1000
            v1 = (JetBrainsAccount)AccountManagerKt.getJba(this.accountManager).getActiveAccount().getValue();
            v2 = v1 != null ? v1.isInternal() : false;
            if (v2) lbl-1000:
            // 2 sources

            {
                v0 = "internal";
            } else {
                v0 = null;
            }
        }
        mode = v0;
        var4_3 = new String[4];
        var4_3[0] = "uuid=" + this.userId;
        var4_3[1] = "build=Toolbox-" + BuildNumber.toString-impl(Build.INSTANCE.getBuildNumber-Y_E1uuk());
        var4_3[2] = "mid=" + this.machineId;
        v3 = var4_3;
        v4 = 3;
        v5 = mode;
        if (v5 != null) {
            var6_4 = v5;
            var15_6 = v4;
            var14_7 = v3;
            $i$a$-let-FeedLocationProvider$feeds$queryParameters$1 = false;
            var16_10 = "mode=" + (String)it;
            v3 = var14_7;
            v4 = var15_6;
            v6 = var16_10;
        } else {
            v6 = null;
        }
        v3[v4] = v6;
        queryParameters = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])var4_3), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        var5_12 = new String[]{"/public-feed.feed.xz.signed?" + queryParameters, OS.INSTANCE.isMacArm() != false ? "/public-feed-arm.feed.xz.signed" : null, "/thirdparty-feed.feed.xz.signed"};
        relativeUrls = CollectionsKt.listOfNotNull((Object[])var5_12);
        $this$map$iv = relativeUrls;
        $i$f$map = false;
        $i$a$-let-FeedLocationProvider$feeds$queryParameters$1 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var12_17 = (String)item$iv$iv;
            var14_7 = destination$iv$iv;
            $i$a$-map-FeedLocationProvider$feeds$1 = false;
            var14_7.add(SelfSettingsKt.getUseStaging(((SelfSettings)this.settingsManager.getSettings().getValue()).getInternal()) ? new FeedLocation("https://secure.staging.toolbox.app/feeds/v1" + (String)it, null, false, 6, null) : this.linkUpdater.updateIfNeeded(new FeedLocation("https://download.jetbrains.com/toolbox/feeds/v1" + (String)it, null, false, 6, null)));
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.previewFeed(reason));
    }

    private final List<FeedLocation> previewFeed(ModelUpdateReason reason) {
        List list2;
        if (AccountManagerKt.getJba(this.accountManager).getActiveAccount().getValue() != null && (this.isSkipPeriodOver() || reason == ModelUpdateReason.USER_REQUEST)) {
            String url = SelfSettingsKt.getUseStaging(((SelfSettings)this.settingsManager.getSettings().getValue()).getInternal()) ? "https://preview.staging.toolbox.app/feeds/v1/preview-feed.feed.xz.signed" : "https://preview.feed.toolbox.app/feeds/v1/preview-feed.feed.xz.signed";
            list2 = CollectionsKt.listOf((Object)new FeedLocation(url, null, true, 2, null));
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final boolean isSkipPeriodOver() {
        return ((Storage)this.storageManager.getStorage().getValue()).getSkipUpdatePreviewFeedUntil() < Clock.System.INSTANCE.now().toEpochMilliseconds();
    }

    @NotNull
    public final String feedFromResources() {
        return switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
            case 1 -> "/bundled-windows.feed";
            case 2 -> "/bundled-mac.feed";
            case 3 -> "/bundled-linux.feed";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

