/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.feature.mcp.client;

import com.jetbrains.toolbox.feature.mcp.client.McpRemoteServerTransport;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface McpServerConfig {

    public static final class Remote
    implements McpServerConfig {
        @NotNull
        private final String url;
        @NotNull
        private final McpRemoteServerTransport transport;
        @Nullable
        private final String authToken;

        public Remote(@NotNull String url, @NotNull McpRemoteServerTransport transport, @Nullable String authToken) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)((Object)transport), (String)"transport");
            this.url = url;
            this.transport = transport;
            this.authToken = authToken;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final McpRemoteServerTransport getTransport() {
            return this.transport;
        }

        @Nullable
        public final String getAuthToken() {
            return this.authToken;
        }
    }

    public static final class Stdio
    implements McpServerConfig {
        @Nullable
        private final String workingDirectory;
        @NotNull
        private final String command;
        @NotNull
        private final List<String> args;
        @NotNull
        private final Map<String, String> env;

        public Stdio(@Nullable String workingDirectory, @NotNull String command2, @NotNull List<String> args, @NotNull Map<String, String> env) {
            Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter(env, (String)"env");
            this.workingDirectory = workingDirectory;
            this.command = command2;
            this.args = args;
            this.env = env;
        }

        @Nullable
        public final String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @NotNull
        public final List<String> getArgs() {
            return this.args;
        }

        @NotNull
        public final Map<String, String> getEnv() {
            return this.env;
        }
    }
}

