/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.environment;

import com.jetbrains.toolbox.common.io.FileSystemWatcher;
import com.jetbrains.toolbox.environment.EnvironmentDescriptorSource$watchEnvironmentFileForChanges$;
import com.jetbrains.toolbox.environment.dto.EnvironmentDescriptorDto;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.okio.OkioStreamsKt;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nEnvironmentDescriptorSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentDescriptorSource.kt\ncom/jetbrains/toolbox/environment/EnvironmentDescriptorSource\n+ 2 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 3 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 4 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n+ 5 Okio.kt\nokio/Okio__OkioKt\n+ 6 FileSystem.kt\nokio/FileSystem\n+ 7 OkioStreams.kt\nkotlinx/serialization/json/okio/OkioStreamsKt\n*L\n1#1,50:1\n17#2:51\n19#2:55\n46#3:52\n51#3:54\n105#4:53\n66#5:56\n52#5,4:58\n60#5,10:64\n56#5,3:74\n71#5,3:77\n67#6:57\n68#6:62\n78#7:63\n*S KotlinDebug\n*F\n+ 1 EnvironmentDescriptorSource.kt\ncom/jetbrains/toolbox/environment/EnvironmentDescriptorSource\n*L\n29#1:51\n29#1:55\n29#1:52\n29#1:54\n29#1:53\n41#1:56\n41#1:58,4\n41#1:64,10\n41#1:74,3\n41#1:77,3\n41#1:57\n41#1:62\n42#1:63\n*E\n"})
public final class EnvironmentDescriptorSource {
    @NotNull
    private final Path environmentFile;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Json json;
    @NotNull
    private final MutableStateFlow<EnvironmentDescriptorDto> _descriptor;
    @NotNull
    private final StateFlow<EnvironmentDescriptorDto> descriptor;

    public EnvironmentDescriptorSource(@NotNull Path environmentFile, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)environmentFile, (String)"environmentFile");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.environmentFile = environmentFile;
        this.fileSystem = fileSystem;
        this.json = JsonKt.Json$default(null, EnvironmentDescriptorSource::json$lambda$0, (int)1, null);
        this._descriptor = StateFlowKt.MutableStateFlow((Object)this.readDescriptorFromFile());
        this.descriptor = (StateFlow)this._descriptor;
    }

    @NotNull
    public final StateFlow<EnvironmentDescriptorDto> getDescriptor() {
        return this.descriptor;
    }

    @Nullable
    public final Object watchEnvironmentFileForChanges(@NotNull FileSystemWatcher fileSystemWatcher, @NotNull Continuation<? super Unit> $completion) {
        Path[] pathArray = new Path[]{this.environmentFile};
        fileSystemWatcher.watch(pathArray);
        Flow $this$filter$iv = (Flow)fileSystemWatcher.getEvents();
        boolean $i$f$filter = false;
        Flow $this$unsafeTransform$iv$iv = $this$filter$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        Object object = FlowKt.collectLatest((Flow)((Flow)new Flow<FileSystemWatcher.Event>($this$unsafeTransform$iv$iv, this){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            final /* synthetic */ EnvironmentDescriptorSource this$0;
            {
                this.$this_unsafeTransform$inlined = flow2;
                this.this$0 = environmentDescriptorSource;
            }

            public Object collect(FlowCollector collector, Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.this$0){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    final /* synthetic */ EnvironmentDescriptorSource this$0;
                    {
                        this.$this_unsafeFlow = $receiver;
                        this.this$0 = environmentDescriptorSource;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object emit(Object value, Continuation $completion) {
                        if (!($completion instanceof watchEnvironmentFileForChanges$$inlined$filter$1$2$1)) ** GOTO lbl-1000
                        var3_3 = $completion;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                Object L$1;
                                final /* synthetic */ watchEnvironmentFileForChanges$$inlined$filter$1$2 this$0;
                                Object L$2;
                                Object L$3;
                                int I$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = $continuation;
                                var7_8 = value;
                                $this$filter_u24lambda_u240 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = 0;
                                var10_14 = (Continuation)$continuation;
                                it = (FileSystemWatcher.Event)value;
                                $i$a$-filter-EnvironmentDescriptorSource$watchEnvironmentFileForChanges$2 = false;
                                if (!(Intrinsics.areEqual((Object)it.getFile(), (Object)EnvironmentDescriptorSource.access$getEnvironmentFile$p(this.this$0)) != false && it.getType() == FileSystemWatcher.EventType.CHANGE)) break;
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$filter_u24lambda_u240);
                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1;
                                $continuation.label = 1;
                                v0 = $this$filter_u24lambda_u240.emit((Object)value, (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                break;
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = $continuation.I$0;
                                $this$filter_u24lambda_u240 = (FlowCollector)$continuation.L$3;
                                value = $continuation.L$2;
                                $completion = $continuation.L$1;
                                value = $continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                break;
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }), (Function2)((Function2)new Function2<FileSystemWatcher.Event, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EnvironmentDescriptorSource this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Logger.INSTANCE.info("Environment file may have changed, reloading");
                        EnvironmentDescriptorSource.access$get_descriptor$p(this.this$0).setValue((Object)EnvironmentDescriptorSource.access$readDescriptorFromFile(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(FileSystemWatcher.Event p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final EnvironmentDescriptorDto readDescriptorFromFile() {
        if (!this.fileSystem.exists(this.environmentFile)) {
            return null;
        }
        try {
            Object var8_11;
            Throwable thrown$iv$iv;
            block16: {
                EnvironmentDescriptorDto environmentDescriptorDto;
                void this_$iv;
                Logger.INSTANCE.info("Loading environment file '" + this.environmentFile + "'");
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = this.environmentFile;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    void $this$decodeFromBufferedSource$iv;
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSource $this$readDescriptorFromFile_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    Json json2 = this.json;
                    BufferedSource source$iv = $this$readDescriptorFromFile_u24lambda_u240;
                    boolean $i$f$decodeFromBufferedSource = false;
                    $this$decodeFromBufferedSource$iv.getSerializersModule();
                    environmentDescriptorDto = (EnvironmentDescriptorDto)OkioStreamsKt.decodeFromBufferedSource((Json)$this$decodeFromBufferedSource$iv, (DeserializationStrategy)((DeserializationStrategy)BuiltinSerializersKt.getNullable(EnvironmentDescriptorDto.Companion.serializer())), (BufferedSource)source$iv);
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        var8_11 = null;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block17: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block17;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable == null) return environmentDescriptorDto;
                    closeable.close();
                    return environmentDescriptorDto;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return environmentDescriptorDto;
            }
            Object result$iv$iv = var8_11;
            Throwable throwable = thrown$iv$iv;
            if (throwable == null) throw new KotlinNothingValueException();
            throw throwable;
        }
        catch (Throwable e) {
            Logger.INSTANCE.error(e, "Failed to load '" + this.environmentFile + "'");
            return null;
        }
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MutableStateFlow access$get_descriptor$p(EnvironmentDescriptorSource $this) {
        return $this._descriptor;
    }

    public static final /* synthetic */ EnvironmentDescriptorDto access$readDescriptorFromFile(EnvironmentDescriptorSource $this) {
        return $this.readDescriptorFromFile();
    }

    public static final /* synthetic */ Path access$getEnvironmentFile$p(EnvironmentDescriptorSource $this) {
        return $this.environmentFile;
    }
}

