/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.machineConfig;

import com.jetbrains.tbe.config.machine.IdeAnalyticsConfig;
import com.jetbrains.tbe.config.machine.TbeMachineConfig;
import com.jetbrains.tbe.config.machine.TbeMachineConfigFactory;
import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import com.jetbrains.toolbox.common.io.Copy_and_moveKt;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.common.platform.OS;
import java.io.Closeable;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.uuid.Uuid;
import kotlinx.datetime.Instant;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nEnterpriseMachineConfigStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnterpriseMachineConfigStorage.kt\ncom/jetbrains/toolbox/enterprise/machineConfig/EnterpriseMachineConfigStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,119:1\n1#2:120\n80#3:121\n165#3:122\n81#3:123\n82#3:128\n67#3:158\n68#3:163\n52#4,4:124\n60#4,10:129\n56#4,18:139\n66#4:157\n52#4,4:159\n60#4,10:164\n56#4,3:174\n71#4,3:177\n*S KotlinDebug\n*F\n+ 1 EnterpriseMachineConfigStorage.kt\ncom/jetbrains/toolbox/enterprise/machineConfig/EnterpriseMachineConfigStorage\n*L\n65#1:121\n65#1:122\n65#1:123\n65#1:128\n105#1:158\n105#1:163\n65#1:124,4\n65#1:129,10\n65#1:139,18\n105#1:157\n105#1:159,4\n105#1:164,10\n105#1:174,3\n105#1:177,3\n*E\n"})
public final class EnterpriseMachineConfigStorage {
    @NotNull
    private final Path adminConfigPath;
    @NotNull
    private final Path userConfigPath;
    @NotNull
    private final FileSystem fileSystem;

    public EnterpriseMachineConfigStorage(@NotNull Path adminConfigPath, @NotNull Path userConfigPath, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)adminConfigPath, (String)"adminConfigPath");
        Intrinsics.checkNotNullParameter((Object)userConfigPath, (String)"userConfigPath");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.adminConfigPath = adminConfigPath;
        this.userConfigPath = userConfigPath;
        this.fileSystem = fileSystem;
    }

    @NotNull
    public final Path getAdminConfigPath() {
        return this.adminConfigPath;
    }

    @NotNull
    public final Path getUserConfigPath() {
        return this.userConfigPath;
    }

    @Nullable
    public final TbeMachineConfig readAdminConfig() {
        TbeMachineConfig config2;
        if (Build.INSTANCE.isSNAPSHOT()) {
            EnterpriseMachineConfigStorage $this$readAdminConfig_u24lambda_u240 = this;
            boolean bl = false;
            String string = System.getenv("TBE_DEBUG_HOST");
            if (string != null && (string = StringExtensionsKt.getNullIfBlank(string)) != null) {
                String host = string;
                Logger.INSTANCE.error("Using TBE DEBUG MODE");
                return new TbeMachineConfig(host){
                    private final String tbeServerUrl;
                    private final String companyName;
                    private final String companyLogoUrl;
                    private final String overriddenAuthorization;
                    private final Instant expiresAt;
                    private final List<X509Certificate> httpsTrustStore;
                    private final String browserUrl;
                    private final Map<String, String> additionalHeaders;
                    private final IdeAnalyticsConfig ideAnalytics;
                    private final String organizationSignatureManifest;
                    {
                        this.tbeServerUrl = $host;
                        this.companyName = "TBE Debug";
                        this.httpsTrustStore = CollectionsKt.emptyList();
                        this.additionalHeaders = MapsKt.emptyMap();
                    }

                    public String getTbeServerUrl() {
                        return this.tbeServerUrl;
                    }

                    public String getCompanyName() {
                        return this.companyName;
                    }

                    public String getCompanyLogoUrl() {
                        return this.companyLogoUrl;
                    }

                    public String getOverriddenAuthorization() {
                        return this.overriddenAuthorization;
                    }

                    public Instant getExpiresAt() {
                        return this.expiresAt;
                    }

                    public List<X509Certificate> getHttpsTrustStore() {
                        return this.httpsTrustStore;
                    }

                    public String getBrowserUrl() {
                        return this.browserUrl;
                    }

                    public Map<String, String> getAdditionalHeaders() {
                        return this.additionalHeaders;
                    }

                    public IdeAnalyticsConfig getIdeAnalytics() {
                        return this.ideAnalytics;
                    }

                    public String getOrganizationSignatureManifest() {
                        return this.organizationSignatureManifest;
                    }
                };
            }
        }
        if ((config2 = this.readConfig(this.adminConfigPath)) != null && FileSystemExtKt.isWritable(this.fileSystem, this.adminConfigPath)) {
            Logger.INSTANCE.warn("The admin enterprise config at " + this.adminConfigPath + " is user-writable");
        }
        return config2;
    }

    @Nullable
    public final TbeMachineConfig readUserConfig() {
        return this.readConfig(this.userConfigPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void saveUserConfig(@NotNull TbeMachineConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        try {
            BufferedSink bufferedSink;
            Throwable thrown$iv$iv;
            Path path2;
            Path tempFilePath;
            block28: {
                void $this$iv;
                boolean bl;
                Path path3;
                block31: {
                    block30: {
                        if (this.fileSystem.exists(this.userConfigPath) && !FileSystemExtKt.isWritable(this.fileSystem, this.userConfigPath)) {
                            Logger.INSTANCE.error("The user enterprise config file at " + this.userConfigPath + " exists and is not writeable, can't save the config!");
                            return;
                        }
                        path3 = this.userConfigPath.parent();
                        if (path3 == null) break block30;
                        Path it = path3;
                        bl = false;
                        Path path4 = it.resolve(Uuid.Companion.random().toString());
                        path3 = path4;
                        if (path4 != null) break block31;
                    }
                    path3 = StandardPaths.INSTANCE.getToolboxCacheLocation().resolve(Uuid.Companion.random().toString()).resolve(this.userConfigPath.name());
                }
                tempFilePath = path3;
                Path path5 = tempFilePath.parent();
                if (path5 != null) {
                    path2 = path5;
                    FileSystem fileSystem = this.fileSystem;
                    Path p0 = path2;
                    bl = false;
                    fileSystem.createDirectories(p0);
                }
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = tempFilePath;
                boolean mustCreate$iv = false;
                boolean bl2 = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl22 = false;
                    BufferedSink $this$saveUserConfig_u24lambda_u241 = it$iv;
                    boolean bl3 = false;
                    bufferedSink = $this$saveUserConfig_u24lambda_u241.write(TbeMachineConfigFactory.INSTANCE.toConfigData(config2));
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        bufferedSink = null;
                        break block28;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block29: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block29;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            BufferedSink result$iv$iv = bufferedSink;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            if (OS.INSTANCE.isWindows()) {
                this.fileSystem.delete(this.userConfigPath);
            }
            Path path6 = this.userConfigPath.parent();
            if (path6 != null) {
                path2 = path6;
                FileSystem fileSystem = this.fileSystem;
                Path p0 = path2;
                boolean bl = false;
                fileSystem.createDirectories(p0);
            }
            Copy_and_moveKt.safeAtomicMove$default(this.fileSystem, tempFilePath, this.userConfigPath, false, 0, 12, null);
            if (!Intrinsics.areEqual((Object)tempFilePath.parent(), (Object)this.userConfigPath.parent())) {
                Path path7 = tempFilePath.parent();
                if (path7 != null) {
                    path2 = path7;
                    FileSystem fileSystem = this.fileSystem;
                    Path p0 = path2;
                    boolean bl = false;
                    fileSystem.delete(p0);
                }
            }
            Logger.INSTANCE.info("The user enterprise config has been successfully saved at " + this.userConfigPath);
            return;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "The user enterprise config can't be saved at " + this.userConfigPath);
        }
    }

    public final void removeUserConfig() {
        try {
            this.fileSystem.delete(this.userConfigPath);
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "The user enterprise config can't be removed at " + this.userConfigPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final TbeMachineConfig readConfig(Path path2) {
        try {
            TbeMachineConfig tbeMachineConfig;
            Throwable thrown$iv$iv;
            block20: {
                void this_$iv;
                if (!this.fileSystem.exists(path2)) {
                    return null;
                }
                if (!FileSystemExtKt.isReadable(this.fileSystem, path2)) {
                    Logger.INSTANCE.warn("The enterprise config at " + path2 + " is not user-readable, skipping");
                    return null;
                }
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = path2;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    TbeMachineConfig tbeMachineConfig2;
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSource $this$readConfig_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    try {
                        tbeMachineConfig2 = TbeMachineConfigFactory.INSTANCE.fromConfigData($this$readConfig_u24lambda_u240.readByteArray());
                    }
                    catch (Exception e) {
                        Logger.INSTANCE.warn((Throwable)e, "Couldn't parse the enterprise config at " + path2);
                        tbeMachineConfig2 = null;
                    }
                    tbeMachineConfig = tbeMachineConfig2;
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        tbeMachineConfig = null;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block21: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block21;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            TbeMachineConfig result$iv$iv = tbeMachineConfig;
            Throwable throwable = thrown$iv$iv;
            if (throwable == null) return result$iv$iv;
            throw throwable;
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Couldn't read the enterprise config at " + path2);
            return null;
        }
    }
}

