/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise.configuration.steps;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.enterprise.configuration.EnterpriseToolInstanceUpdater;
import com.jetbrains.toolbox.enterprise.configuration.steps.EnterpriseRequiredPluginsConfigurationStep;
import com.jetbrains.toolbox.enterprise.configuration.steps.EnterpriseToolConfigurationStep;
import com.jetbrains.toolbox.enterprise.plugins.EnterprisePluginsBatchLoader;
import com.jetbrains.toolbox.enterprise.plugins.EnterpriseRequiredPluginsManager;
import com.jetbrains.toolbox.enterprise.rest.EnabledPluginOptionsV2;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.JobKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nEnterpriseRequiredPluginsConfigurationStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnterpriseRequiredPluginsConfigurationStep.kt\ncom/jetbrains/toolbox/enterprise/configuration/steps/EnterpriseRequiredPluginsConfigurationStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1869#2,2:74\n*S KotlinDebug\n*F\n+ 1 EnterpriseRequiredPluginsConfigurationStep.kt\ncom/jetbrains/toolbox/enterprise/configuration/steps/EnterpriseRequiredPluginsConfigurationStep\n*L\n38#1:74,2\n*E\n"})
public final class EnterpriseRequiredPluginsConfigurationStep
implements EnterpriseToolConfigurationStep {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final EnterpriseRequiredPluginsManager enterpriseRequiredPluginsManager;
    @NotNull
    private final EnabledPluginOptionsV2 enabledPlugins;
    @NotNull
    private final List<EnterprisePluginsBatchLoader.Result> downloadedPlugins;
    @NotNull
    private final EnterpriseToolInstanceUpdater enterpriseToolInstanceUpdater;
    @NotNull
    private final LocalizableString displayName;

    public EnterpriseRequiredPluginsConfigurationStep(@NotNull FileSystem fileSystem, @NotNull EnterpriseRequiredPluginsManager enterpriseRequiredPluginsManager, @NotNull EnabledPluginOptionsV2 enabledPlugins, @NotNull List<EnterprisePluginsBatchLoader.Result> downloadedPlugins, @NotNull EnterpriseToolInstanceUpdater enterpriseToolInstanceUpdater) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)enterpriseRequiredPluginsManager, (String)"enterpriseRequiredPluginsManager");
        Intrinsics.checkNotNullParameter((Object)enabledPlugins, (String)"enabledPlugins");
        Intrinsics.checkNotNullParameter(downloadedPlugins, (String)"downloadedPlugins");
        Intrinsics.checkNotNullParameter((Object)enterpriseToolInstanceUpdater, (String)"enterpriseToolInstanceUpdater");
        this.fileSystem = fileSystem;
        this.enterpriseRequiredPluginsManager = enterpriseRequiredPluginsManager;
        this.enabledPlugins = enabledPlugins;
        this.downloadedPlugins = downloadedPlugins;
        this.enterpriseToolInstanceUpdater = enterpriseToolInstanceUpdater;
        this.displayName = LocalizableStringExKt.trl("Installing plugins\u2026");
    }

    @Override
    @NotNull
    public LocalizableString getDisplayName() {
        return this.displayName;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object execute(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ EnterpriseRequiredPluginsConfigurationStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, (Continuation<? super ToolInstance>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.enabledPlugins.getAutoInstalled().isEmpty()) {
                    return this.enterpriseToolInstanceUpdater.updateToolInstanceWithoutEnterpriseRequiredPlugins(toolInstance);
                }
                result = toolInstance;
                if (!(((Collection)this.downloadedPlugins).isEmpty() == false)) ** GOTO lbl48
                toolName = InstalledToolKt.displayNameWithVersion(toolInstance.getChannel(), toolInstance.getTool());
                Logger.INSTANCE.info("Installing TBE required plugins for " + toolName);
                deleteDownloadedPlugins = (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$0(com.jetbrains.toolbox.enterprise.configuration.steps.EnterpriseRequiredPluginsConfigurationStep ), ()Lkotlin/Unit;)((EnterpriseRequiredPluginsConfigurationStep)this);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)toolInstance);
                $continuation.L$1 = result;
                $continuation.L$2 = toolName;
                $continuation.L$3 = deleteDownloadedPlugins;
                $continuation.label = 1;
                v0 = this.enterpriseRequiredPluginsManager.installPlugins(result, this.downloadedPlugins, this.enabledPlugins, (Continuation<? super ToolInstance>)$continuation);
                ** if (v0 != var10_5) goto lbl29
lbl28:
                // 1 sources

                return var10_5;
lbl29:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                deleteDownloadedPlugins = (Function0)$continuation.L$3;
                toolName = (String)$continuation.L$2;
                result = (ToolInstance)$continuation.L$1;
                toolInstance = (ToolInstance)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl39:
                    // 2 sources

                    var6_9 = (ToolInstance)v0;
                }
                catch (Exception e) {
                    deleteDownloadedPlugins.invoke();
                    JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                    Logger.INSTANCE.warn((Throwable)e, "Failed to install TBE required plugins for " + toolName);
                    var6_9 = result;
                }
                result = var6_9;
lbl48:
                // 2 sources

                result = this.enterpriseToolInstanceUpdater.updateToolInstanceWithEnterpriseRequiredPlugins(result, this.enabledPlugins.getAutoInstalled());
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit execute$lambda$0(EnterpriseRequiredPluginsConfigurationStep this$0) {
        Iterable $this$forEach$iv = this$0.downloadedPlugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path2;
            EnterprisePluginsBatchLoader.Result it = (EnterprisePluginsBatchLoader.Result)element$iv;
            boolean bl = false;
            if (it.getDownloadResult().getPath() == null) continue;
            Path path3 = path2;
            boolean bl2 = false;
            try {
                this$0.fileSystem.deleteRecursively(path3);
            }
            catch (IOException e) {
                Logger.INSTANCE.warn((Throwable)e, "Unable to remove downloaded plugin at " + path3);
            }
        }
        return Unit.INSTANCE;
    }
}

