/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.enterprise;

import com.jetbrains.toolbox.intellij.notifications.PluginInfo;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nEnterpriseNotificationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnterpriseNotificationManager.kt\ncom/jetbrains/toolbox/enterprise/EnterpriseNotificationManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,63:1\n382#2,7:64\n488#2,7:72\n488#2,7:79\n1#3:71\n216#4,2:86\n*S KotlinDebug\n*F\n+ 1 EnterpriseNotificationManager.kt\ncom/jetbrains/toolbox/enterprise/EnterpriseNotificationManager\n*L\n29#1:64,7\n49#1:72,7\n54#1:79,7\n54#1:86,2\n*E\n"})
public final class EnterpriseNotificationManager {
    @NotNull
    private final Clock clock;
    @NotNull
    private final AtomicLong counter;
    @NotNull
    private final Map<String, ConcurrentHashMap<UniqueTimeKey, PluginInfo>> installedPlugins;
    @NotNull
    private final Map<String, ConcurrentHashMap<UniqueTimeKey, PluginInfo>> disabledPlugins;
    @NotNull
    private final ConcurrentHashMap<String, Instant> vmOptionsChanged;

    public EnterpriseNotificationManager(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        this.counter = new AtomicLong();
        this.installedPlugins = new LinkedHashMap();
        this.disabledPlugins = new LinkedHashMap();
        this.vmOptionsChanged = new ConcurrentHashMap();
    }

    public final void addInstalledPluginInfo(@NotNull ToolInstance item2, @NotNull PluginInfo info) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.addInfo(item2, info, this.installedPlugins);
    }

    /*
     * WARNING - void declaration
     */
    private final void addInfo(ToolInstance item2, PluginInfo info, Map<String, ConcurrentHashMap<UniqueTimeKey, PluginInfo>> map2) {
        Object object;
        void $this$getOrPut$iv;
        Map<String, ConcurrentHashMap<UniqueTimeKey, PluginInfo>> map3 = map2;
        String key$iv = this.key(item2);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ConcurrentHashMap answer$iv = new ConcurrentHashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ConcurrentHashMap infosToInstants = (ConcurrentHashMap)object;
        ((Map)infosToInstants).put(new UniqueTimeKey(this.clock.now(), this.counter.incrementAndGet()), info);
    }

    private final String key(ToolInstance $this$key) {
        return $this$key.getChannel().getInstallationDirectory().toString();
    }

    private static final class UniqueTimeKey {
        @NotNull
        private final Instant time;
        private final long order;

        public UniqueTimeKey(@NotNull Instant time2, long order) {
            Intrinsics.checkNotNullParameter((Object)time2, (String)"time");
            this.time = time2;
            this.order = order;
        }

        @NotNull
        public String toString() {
            return "UniqueTimeKey(time=" + this.time + ", order=" + this.order + ")";
        }

        public int hashCode() {
            int result2 = this.time.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.order);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UniqueTimeKey)) {
                return false;
            }
            UniqueTimeKey uniqueTimeKey = (UniqueTimeKey)other;
            if (!Intrinsics.areEqual((Object)this.time, (Object)uniqueTimeKey.time)) {
                return false;
            }
            return this.order == uniqueTimeKey.order;
        }
    }
}

