/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.educational;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.educational.EducationalToolReconfigurator;
import com.jetbrains.toolbox.educational.JetBrainsAcademyPluginInstaller;
import com.jetbrains.toolbox.educational.OpenCourseRequest;
import com.jetbrains.toolbox.educational.PluginInfo;
import com.jetbrains.toolbox.educational.PluginInfoKt;
import com.jetbrains.toolbox.feed.PluginId;
import com.jetbrains.toolbox.i18n.LocalizableStringEx;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.tools.ToolUninstaller;
import com.jetbrains.toolbox.tools.UninstallResult;
import com.jetbrains.toolbox.tools.launcher.ProcessLauncher;
import com.jetbrains.toolbox.tools.launcher.ProcessParameters;
import com.jetbrains.toolbox.tools.launcher.ToolParameters;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolReconfigurator;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class EducationalToolReconfigurator
implements ToolReconfigurator {
    @NotNull
    private final JetBrainsAcademyPluginInstaller jetBrainsAcademyPluginInstaller;
    @NotNull
    private final ProcessLauncher processLauncher;
    @NotNull
    private final ToolUninstaller toolUninstaller;
    @NotNull
    private final OpenCourseRequest openCourseRequest;
    @NotNull
    private final MutableStateFlow<State> _progress;
    @NotNull
    private final StateFlow<State> progress;
    @NotNull
    private final MutableStateFlow<LocalizableStringEx> displayNameState;
    @NotNull
    private final StateFlow<LocalizableString> displayName;

    public EducationalToolReconfigurator(@NotNull JetBrainsAcademyPluginInstaller jetBrainsAcademyPluginInstaller, @NotNull ProcessLauncher processLauncher, @NotNull ToolUninstaller toolUninstaller, @NotNull OpenCourseRequest openCourseRequest) {
        Intrinsics.checkNotNullParameter((Object)jetBrainsAcademyPluginInstaller, (String)"jetBrainsAcademyPluginInstaller");
        Intrinsics.checkNotNullParameter((Object)processLauncher, (String)"processLauncher");
        Intrinsics.checkNotNullParameter((Object)toolUninstaller, (String)"toolUninstaller");
        Intrinsics.checkNotNullParameter((Object)openCourseRequest, (String)"openCourseRequest");
        this.jetBrainsAcademyPluginInstaller = jetBrainsAcademyPluginInstaller;
        this.processLauncher = processLauncher;
        this.toolUninstaller = toolUninstaller;
        this.openCourseRequest = openCourseRequest;
        this._progress = StateFlowKt.MutableStateFlow((Object)State.NotStarted.INSTANCE);
        this.progress = FlowKt.asStateFlow(this._progress);
        this.displayNameState = StateFlowKt.MutableStateFlow((Object)LocalizableStringExKt.trl("Preparing for course launch\u2026"));
        this.displayName = FlowKt.asStateFlow(this.displayNameState);
    }

    @NotNull
    public final StateFlow<State> getProgress() {
        return this.progress;
    }

    @Override
    @NotNull
    public StateFlow<LocalizableString> getDisplayName() {
        return this.displayName;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object reconfigure(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        block21: {
            if (!($completion instanceof reconfigure.1)) ** GOTO lbl-1000
            var10_3 = $completion;
            if ((var10_3.label & -2147483648) != 0) {
                var10_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    boolean Z$0;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ EducationalToolReconfigurator this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.reconfigure(null, (Continuation<? super ToolInstance>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = toolInstance;
                    $continuation.label = 1;
                    v0 = this._progress.emit((Object)State.InProgress.INSTANCE, (Continuation)$continuation);
                    if (v0 == var11_5) {
                        return var11_5;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    toolInstance = (ToolInstance)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    pluginInfo = new PluginInfo(PluginInfoKt.getJetBrainsAcademyPluginId(), "JetBrainsAcademy", this.openCourseRequest.getMinPluginVersion-Y_E1uuk(), this.openCourseRequest.getPluginChannel(), null);
                    $continuation.L$0 = toolInstance;
                    $continuation.L$1 = pluginInfo;
                    $continuation.label = 2;
                    v1 = this.displayNameState.emit((Object)LocalizableStringExKt.trl("Installing JetBrains Academy plugin\u2026"), (Continuation)$continuation);
                    if (v1 == var11_5) {
                        return var11_5;
                    }
                    ** GOTO lbl35
                }
                case 2: {
                    pluginInfo = (PluginInfo)$continuation.L$1;
                    toolInstance = (ToolInstance)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl35:
                    // 2 sources

                    $continuation.L$0 = toolInstance;
                    $continuation.L$1 = pluginInfo;
                    $continuation.label = 3;
                    v2 = this.jetBrainsAcademyPluginInstaller.installJetBrainsAcademyPlugin(toolInstance, pluginInfo, (Continuation<? super Boolean>)$continuation);
                    if (v2 == var11_5) {
                        return var11_5;
                    }
                    ** GOTO lbl47
                }
                case 3: {
                    pluginInfo = (PluginInfo)$continuation.L$1;
                    toolInstance = (ToolInstance)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl47:
                    // 2 sources

                    if (pluginInstalled = ((Boolean)v2).booleanValue()) break;
                    Logger.INSTANCE.warn("Failed to install `" + PluginId.toString-impl(pluginInfo.getPluginId-b6BwIdc()) + "` plugin");
                    $continuation.L$0 = toolInstance;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)pluginInfo);
                    $continuation.Z$0 = pluginInstalled;
                    $continuation.label = 4;
                    v3 = this._progress.emit((Object)new State.Finished(false, false), (Continuation)$continuation);
                    if (v3 == var11_5) {
                        return var11_5;
                    }
                    ** GOTO lbl63
                }
                case 4: {
                    pluginInstalled = $continuation.Z$0;
                    pluginInfo = (PluginInfo)$continuation.L$1;
                    toolInstance = (ToolInstance)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl63:
                    // 2 sources

                    return toolInstance;
                }
            }
            $continuation.L$0 = toolInstance;
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)pluginInfo);
            $continuation.Z$0 = pluginInstalled;
            $continuation.label = 5;
            v4 = this.toolUninstaller.canUninstall(toolInstance, (Continuation<? super UninstallResult>)$continuation);
            if (v4 == var11_5) {
                return var11_5;
            }
            ** GOTO lbl78
            {
                case 5: {
                    pluginInstalled = $continuation.Z$0;
                    pluginInfo = (PluginInfo)$continuation.L$1;
                    toolInstance = (ToolInstance)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl78:
                    // 2 sources

                    if (!Intrinsics.areEqual((Object)(canUninstall = (UninstallResult)v4), (Object)UninstallResult.Success.INSTANCE)) break;
                    $continuation.L$0 = toolInstance;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)pluginInfo);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)canUninstall);
                    $continuation.Z$0 = pluginInstalled;
                    $continuation.label = 6;
                    v5 = this.displayNameState.emit((Object)LocalizableStringExKt.trl("Installing additional plugins for course\u2026"), (Continuation)$continuation);
                    if (v5 == var11_5) {
                        return var11_5;
                    }
                    ** GOTO lbl95
                }
                case 6: {
                    pluginInstalled = $continuation.Z$0;
                    canUninstall = (UninstallResult)$continuation.L$2;
                    pluginInfo = (PluginInfo)$continuation.L$1;
                    toolInstance = (ToolInstance)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl95:
                    // 2 sources

                    try {
                        this.installCoursePlugins(toolInstance);
                        var7_14 = 1;
                    }
                    catch (Exception e) {
                        Logger.INSTANCE.error((Throwable)e, "Failed to install additional course plugins via `installCoursePlugins` command");
                        var7_14 = 0;
                    }
                    v6 = var7_14;
                    break block21;
                }
            }
            v6 = 0;
        }
        additionalPluginsInstalled = v6;
        $continuation.L$0 = toolInstance;
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)pluginInfo);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)canUninstall);
        $continuation.Z$0 = pluginInstalled;
        $continuation.I$0 = additionalPluginsInstalled;
        $continuation.label = 7;
        v7 = this._progress.emit((Object)new State.Finished(true, additionalPluginsInstalled != 0), (Continuation)$continuation);
        if (v7 == var11_5) {
            return var11_5;
        }
        ** GOTO lbl126
        {
            case 7: {
                additionalPluginsInstalled = $continuation.I$0;
                pluginInstalled = $continuation.Z$0;
                canUninstall = (UninstallResult)$continuation.L$2;
                pluginInfo = (PluginInfo)$continuation.L$1;
                toolInstance = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl126:
                // 2 sources

                return toolInstance;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void installCoursePlugins(ToolInstance toolInstance) {
        Object[] objectArray = new String[]{"installCoursePlugins", "--" + this.openCourseRequest.getSource(), this.openCourseRequest.getCourseId(), "-Djava.awt.headless=true"};
        this.processLauncher.launch(ToolParameters.Companion.of(toolInstance), new ProcessParameters(CollectionsKt.listOf((Object[])objectArray), true, true, null, null, null, null, 120, null));
    }

    public static sealed interface State {

        public static final class Finished
        implements State {
            private final boolean jetBrainsAcademyPluginInstalled;
            private final boolean additionalPluginsInstalled;

            public Finished(boolean jetBrainsAcademyPluginInstalled, boolean additionalPluginsInstalled) {
                this.jetBrainsAcademyPluginInstalled = jetBrainsAcademyPluginInstalled;
                this.additionalPluginsInstalled = additionalPluginsInstalled;
            }

            public final boolean getJetBrainsAcademyPluginInstalled() {
                return this.jetBrainsAcademyPluginInstalled;
            }

            @NotNull
            public String toString() {
                return "Finished(jetBrainsAcademyPluginInstalled=" + this.jetBrainsAcademyPluginInstalled + ", additionalPluginsInstalled=" + this.additionalPluginsInstalled + ")";
            }

            public int hashCode() {
                int result2 = Boolean.hashCode(this.jetBrainsAcademyPluginInstalled);
                result2 = result2 * 31 + Boolean.hashCode(this.additionalPluginsInstalled);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Finished)) {
                    return false;
                }
                Finished finished = (Finished)other;
                if (this.jetBrainsAcademyPluginInstalled != finished.jetBrainsAcademyPluginInstalled) {
                    return false;
                }
                return this.additionalPluginsInstalled == finished.additionalPluginsInstalled;
            }
        }

        public static final class InProgress
        implements State {
            @NotNull
            public static final InProgress INSTANCE = new InProgress();

            private InProgress() {
            }

            @NotNull
            public String toString() {
                return "InProgress";
            }

            public int hashCode() {
                return -302821307;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof InProgress)) {
                    return false;
                }
                InProgress cfr_ignored_0 = (InProgress)other;
                return true;
            }
        }

        public static final class NotStarted
        implements State {
            @NotNull
            public static final NotStarted INSTANCE = new NotStarted();

            private NotStarted() {
            }

            @NotNull
            public String toString() {
                return "NotStarted";
            }

            public int hashCode() {
                return -2086405119;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NotStarted)) {
                    return false;
                }
                NotStarted cfr_ignored_0 = (NotStarted)other;
                return true;
            }
        }
    }
}

