/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ea;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.BuildKt;
import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.EuaConfig;
import com.jetbrains.toolbox.ea.ExceptionData;
import com.jetbrains.toolbox.ea.ExceptionSubmitter;
import com.jetbrains.toolbox.ea.ExceptionSubmitterImpl;
import com.jetbrains.toolbox.ea.GzippedRequestBody;
import com.jetbrains.toolbox.network.DownloadManager;
import com.jetbrains.toolbox.network.DownloadSession;
import com.jetbrains.toolbox.network.DownloadSessionUtilKt;
import java.io.Closeable;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nExceptionSubmitterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionSubmitterImpl.kt\ncom/jetbrains/toolbox/ea/ExceptionSubmitterImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public final class ExceptionSubmitterImpl
implements ExceptionSubmitter {
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final EuaConfig euaConfig;
    @NotNull
    private final String submitUrl;

    public ExceptionSubmitterImpl(@NotNull DownloadManager downloadManager, @NotNull EuaConfig euaConfig, @NotNull String submitUrl) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)euaConfig, (String)"euaConfig");
        Intrinsics.checkNotNullParameter((Object)submitUrl, (String)"submitUrl");
        this.downloadManager = downloadManager;
        this.euaConfig = euaConfig;
        this.submitUrl = submitUrl;
    }

    public /* synthetic */ ExceptionSubmitterImpl(DownloadManager downloadManager, EuaConfig euaConfig, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "https://ea-report.jetbrains.com/trackerRpc/idea/createScr";
        }
        this(downloadManager, euaConfig, string);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object submit(@NotNull ExceptionData exception, @NotNull Continuation<? super Integer> $completion) {
        if (!($completion instanceof submit.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ExceptionSubmitterImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.submit(null, (Continuation<? super Integer>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = exception;
                $continuation.label = 1;
                v0 = this.downloadManager.createSession((Continuation<? super DownloadSession>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                exception = (ExceptionData)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                httpClient = ((DownloadSession)v0).getHttpClient();
                request = new Request.Builder().url(this.submitUrl).header("User-Agent", Build.INSTANCE.getUserAgent()).header("Content-Encoding", "gzip").post(this.gzip(this.createBody(exception))).build();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)exception);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)httpClient);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(httpClient, request, null){
                    int label;
                    final /* synthetic */ OkHttpClient $httpClient;
                    final /* synthetic */ Request $request;
                    {
                        this.$httpClient = $httpClient;
                        this.$request = $request;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = DownloadSessionUtilKt.await(this.$httpClient.newCall(this.$request), (Continuation<? super Response>)((Continuation)this));
                                if (v0 == var9_2) {
                                    return var9_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                if (!(response = (Response)v0).isSuccessful()) {
                                    response.close();
                                    Logger.INSTANCE.error("Exception submission unsuccessful: " + response.code() + " " + response.message());
                                } else {
                                    v1 = response.body();
                                    if (v1 != null) {
                                        var5_4 = v1;
                                        var6_5 = null;
                                        try {
                                            it = (ResponseBody)var5_4;
                                            $i$a$-use-ExceptionSubmitterImpl$submit$2$body$1 = false;
                                            var7_6 = it.string();
                                            v2 = var7_6;
                                        }
                                        catch (Throwable var8_8) {
                                            var6_5 = var8_8;
                                            throw var8_8;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)var5_4, (Throwable)var6_5);
                                        }
                                    } else {
                                        v2 = null;
                                    }
                                    v3 = body = v2;
                                    v4 = id = v3 != null ? StringsKt.toIntOrNull(v3) : null;
                                    if (id != null) {
                                        return id;
                                    }
                                    Logger.INSTANCE.error("Exception submission failed: " + body);
                                }
                                return null;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl38
            }
            case 2: {
                request = (Request)$continuation.L$2;
                httpClient = (OkHttpClient)$continuation.L$1;
                exception = (ExceptionData)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl38:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final RequestBody createBody(ExceptionData exception) {
        String string;
        FormBody.Builder builder = new FormBody.Builder(null, 1, null).add("protocol.version", "1.1");
        String string2 = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        FormBody.Builder builder2 = builder.add("os.cpu.arch", string2);
        String string3 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
        FormBody.Builder builder3 = builder2.add("os.name", string3);
        String string4 = System.getProperty("java.runtime.version", System.getProperty("java.version"));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProperty(...)");
        FormBody.Builder builder4 = builder3.add("java.version", string4);
        String string5 = System.getProperty("java.vm.vendor", "Unknown");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getProperty(...)");
        FormBody.Builder builder5 = builder4.add("java.vm.vendor", string5).add("app.name", "Toolbox App").add("app.name.full", "Toolbox App").add("app.name.version", Build.INSTANCE.getApplicationFullNameVersion()).add("app.eap", String.valueOf(this.euaConfig.isEap())).add("app.internal", String.valueOf(Build.INSTANCE.isSNAPSHOT())).add("app.build", "TB-" + BuildNumber.toString-impl(Build.INSTANCE.getBuildNumber-Y_E1uuk())).add("app.version.major", BuildKt.getVersionNumber(Build.INSTANCE));
        String string6 = "app.version.minor";
        Object object = BuildNumber.getComponents-impl(Build.INSTANCE.getBuildNumber-Y_E1uuk());
        int n = 2;
        if (n < object.size()) {
            string = object.get(n);
        } else {
            int n2 = n;
            String string7 = string6;
            FormBody.Builder builder6 = builder5;
            boolean bl = false;
            String string8 = "0";
            builder5 = builder6;
            string6 = string7;
            string = string8;
        }
        Object $this$createBody_u24lambda_u241 = object = builder5.add(string6, string).add("app.build.date", String.valueOf(Build.INSTANCE.getBuildDate().toEpochMilliseconds())).add("app.build.date.release", "unknown").add("app.product.code", "TB").add("app.build.number", BuildNumber.toString-impl(Build.INSTANCE.getBuildNumber-Y_E1uuk())).add("app.vcs.commit", Build.INSTANCE.getCommitHash()).add("user.login", "idea_anonymous").add("user.password", "guest");
        boolean bl = false;
        if (((CharSequence)exception.getMessage()).length() > 0) {
            ((FormBody.Builder)$this$createBody_u24lambda_u241).add("error.message", exception.getMessage());
        }
        return ((FormBody.Builder)object).add("error.stacktrace", exception.stackTraceToString()).build();
    }

    @NotNull
    public final RequestBody gzip(@NotNull RequestBody $this$gzip) {
        Intrinsics.checkNotNullParameter((Object)$this$gzip, (String)"<this>");
        return new GzippedRequestBody($this$gzip);
    }
}

