/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ea;

import com.jetbrains.toolbox.ea.ExceptionCollector;
import kotlin.coroutines.AbstractCoroutineContextElement;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.CoroutineExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class CoroutineExceptionReporter
extends AbstractCoroutineContextElement
implements CoroutineExceptionHandler {
    @NotNull
    private final ExceptionCollector exceptionCollector;

    public CoroutineExceptionReporter(@NotNull ExceptionCollector exceptionCollector) {
        Intrinsics.checkNotNullParameter((Object)exceptionCollector, (String)"exceptionCollector");
        super((CoroutineContext.Key)CoroutineExceptionHandler.Key);
        this.exceptionCollector = exceptionCollector;
    }

    public void handleException(@NotNull CoroutineContext context2, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Logger.INSTANCE.error("Unhandled exception in a coroutine " + Reflection.getOrCreateKotlinClass(exception.getClass()).getSimpleName() + ": " + exception.getMessage());
        Logger.INSTANCE.debug(exception);
        this.exceptionCollector.log(exception);
    }
}

