/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.dotDesktopFiles;

import com.jetbrains.toolbox.dotDesktopFiles.DotDesktopFileChannelExtension;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.interop.Processes;
import com.jetbrains.toolbox.shell.ShellEnvironment;
import com.jetbrains.toolbox.tools.model.Channel;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\ncom/jetbrains/toolbox/dotDesktopFiles/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Okio.kt\nokio/Okio__OkioKt\n+ 4 FileSystem.kt\nokio/FileSystem\n*L\n1#1,71:1\n808#2,11:72\n66#3:83\n52#3,4:85\n60#3,10:90\n56#3,3:100\n71#3,3:103\n67#4:84\n68#4:89\n*S KotlinDebug\n*F\n+ 1 Util.kt\ncom/jetbrains/toolbox/dotDesktopFiles/UtilKt\n*L\n11#1:72,11\n30#1:83\n30#1:85,4\n30#1:90,10\n30#1:100,3\n30#1:103,3\n30#1:84\n30#1:89\n*E\n"})
public final class UtilKt {
    @NotNull
    private static final Regex desktopFileSectionRegex = new Regex("^\\[(?>(?![\\[\\]])[\\x00-\\x7F])*]$");

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final DotDesktopFileChannelExtension getDotDesktopFileChannelExtension(@NotNull Channel $this$dotDesktopFileChannelExtension) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$dotDesktopFileChannelExtension, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$dotDesktopFileChannelExtension.getExtensions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof DotDesktopFileChannelExtension)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (DotDesktopFileChannelExtension)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static final Map<String, String> parseDotDesktopFile(@NotNull FileSystem $this$parseDotDesktopFile, @NotNull Path dotDesktopFilePath) {
        Unit unit;
        Throwable thrown$iv$iv;
        Map result2;
        block18: {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)$this$parseDotDesktopFile, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)dotDesktopFilePath, (String)"dotDesktopFilePath");
            result2 = new LinkedHashMap();
            Long length = $this$parseDotDesktopFile.metadata(dotDesktopFilePath).getSize();
            if (length == null) {
                Logger.INSTANCE.debug("Can't obtain size of '" + dotDesktopFilePath + "', treating the file as empty");
                return result2;
            }
            if (length > 50000L) {
                Logger.INSTANCE.debug("The desktop file '" + dotDesktopFilePath + "' is  suspiciously large (" + length + " bytes), treating the file as empty");
                return result2;
            }
            FileSystem fileSystem = $this$parseDotDesktopFile;
            Path file$iv = dotDesktopFilePath;
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSource $this$parseDotDesktopFile_u24lambda_u240 = it$iv;
                boolean bl3 = false;
                while ($this$parseDotDesktopFile_u24lambda_u240.readUtf8Line() != null) {
                    String line;
                    if (StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null) || ((CharSequence)line).length() == 0) continue;
                    MatchResult match2 = desktopFileSectionRegex.matchEntire((CharSequence)line);
                    if (match2 != null) {
                        if (!Intrinsics.areEqual((Object)line, (Object)"[Desktop Entry]")) break;
                        continue;
                    }
                    char[] cArray = new char[]{'='};
                    List split = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)2, (int)2, null);
                    if (split.size() != 2) continue;
                    String key = (String)split.get(0);
                    String value2 = (String)split.get(1);
                    result2.put(key, value2);
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    unit = null;
                    break block18;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block19: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block19;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        Unit result$iv$iv = unit;
        Throwable throwable = thrown$iv$iv;
        if (throwable == null) return result2;
        throw throwable;
    }

    public static final void updateMimeTypesCacheDb(@NotNull ShellEnvironment $this$updateMimeTypesCacheDb, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)$this$updateMimeTypesCacheDb, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Path udd = $this$updateMimeTypesCacheDb.findExecutable("update-desktop-database");
        if (udd != null) {
            ProcessRunner.forkProcessNoWait$default((ProcessRunner)Processes.INSTANCE, udd, CollectionsKt.listOf((Object)path2.toString()), null, null, null, null, null, 124, null);
        } else {
            Logger.INSTANCE.debug("update-desktop-database not found");
        }
    }
}

