/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.devcontainers.launcher;

import com.jetbrains.toolbox.api.remoteDev.states.EnvironmentDescription;
import com.jetbrains.toolbox.devcontainers.agent.deployer.DockerToolboxAgentDeployer;
import com.jetbrains.toolbox.devcontainers.launcher.DevcontainersConnection;
import com.jetbrains.toolbox.docker.DockerEngine;
import com.jetbrains.toolbox.gateway.DevEnvironment;
import com.jetbrains.toolbox.gateway.DevEnvironmentFeature;
import com.jetbrains.toolbox.gateway.RawInterfacesFactory;
import com.jetbrains.toolbox.gateway.states.AgentState;
import com.jetbrains.toolbox.rpc.RemoteToolboxClientFactory;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.NotNull;

public final class DevcontainersConnectionFactory {
    @NotNull
    private final DockerEngine dockerEngine;
    @NotNull
    private final DockerToolboxAgentDeployer dockerToolboxAgentDeployer;
    @NotNull
    private final RemoteToolboxClientFactory clientFactory;
    @NotNull
    private final RawInterfacesFactory rawInterfacesFactory;

    public DevcontainersConnectionFactory(@NotNull DockerEngine dockerEngine, @NotNull DockerToolboxAgentDeployer dockerToolboxAgentDeployer, @NotNull RemoteToolboxClientFactory clientFactory, @NotNull RawInterfacesFactory rawInterfacesFactory) {
        Intrinsics.checkNotNullParameter((Object)dockerEngine, (String)"dockerEngine");
        Intrinsics.checkNotNullParameter((Object)dockerToolboxAgentDeployer, (String)"dockerToolboxAgentDeployer");
        Intrinsics.checkNotNullParameter((Object)clientFactory, (String)"clientFactory");
        Intrinsics.checkNotNullParameter((Object)rawInterfacesFactory, (String)"rawInterfacesFactory");
        this.dockerEngine = dockerEngine;
        this.dockerToolboxAgentDeployer = dockerToolboxAgentDeployer;
        this.clientFactory = clientFactory;
        this.rawInterfacesFactory = rawInterfacesFactory;
    }

    @NotNull
    public final DevcontainersConnection create(@NotNull DevEnvironment devEnvironment, @NotNull List<? extends DevEnvironmentFeature> devEnvironmentFeatures, @NotNull MutableStateFlow<AgentState> agentState, @NotNull MutableStateFlow<EnvironmentDescription> descriptionState, boolean forcefulDeploy, @NotNull CoroutineScope outerScope) {
        Intrinsics.checkNotNullParameter((Object)devEnvironment, (String)"devEnvironment");
        Intrinsics.checkNotNullParameter(devEnvironmentFeatures, (String)"devEnvironmentFeatures");
        Intrinsics.checkNotNullParameter(agentState, (String)"agentState");
        Intrinsics.checkNotNullParameter(descriptionState, (String)"descriptionState");
        Intrinsics.checkNotNullParameter((Object)outerScope, (String)"outerScope");
        return new DevcontainersConnection(this.dockerEngine, devEnvironment, devEnvironmentFeatures, agentState, descriptionState, this.dockerToolboxAgentDeployer, forcefulDeploy, this.clientFactory, this.rawInterfacesFactory, outerScope);
    }
}

