/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.devcontainers.agent;

import com.jetbrains.toolbox.devcontainers.Devcontainer;
import com.jetbrains.toolbox.devcontainers.Devcontainers;
import com.jetbrains.toolbox.devcontainers.gateway.GatewayServices;
import com.jetbrains.toolbox.devcontainers.launcher.DevcontainerEnvironment;
import com.jetbrains.toolbox.devcontainers.launcher.DevcontainersConnectionFactory;
import com.jetbrains.toolbox.gateway.DevEnvironmentProviderId;
import com.jetbrains.toolbox.gateway.RawInterfaces;
import com.jetbrains.toolbox.gateway.ToolToConnectionAssociationManager;
import com.jetbrains.toolbox.gateway.impl.ClientConnectionTracker;
import com.jetbrains.toolbox.jbclient.clientLink.JBClientConnectionHandleManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nDevcontainerToolboxAgents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerToolboxAgents.kt\ncom/jetbrains/toolbox/devcontainers/agent/DevcontainerToolboxAgents\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n72#2,2:77\n72#2,2:79\n72#2,2:83\n1#3:81\n1#3:82\n1#3:85\n*S KotlinDebug\n*F\n+ 1 DevcontainerToolboxAgents.kt\ncom/jetbrains/toolbox/devcontainers/agent/DevcontainerToolboxAgents\n*L\n33#1:77,2\n39#1:79,2\n50#1:83,2\n39#1:81\n33#1:82\n50#1:85\n*E\n"})
public final class DevcontainerToolboxAgents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DevcontainersConnectionFactory devcontainersConnectionFactory;
    @NotNull
    private final GatewayServices gatewayServices;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentHashMap<String, MutableStateFlow<State>> states;
    @NotNull
    private final ConcurrentHashMap<String, DevcontainerEnvironment> devcontainerEnvironments;
    @NotNull
    private static final String providerId = DevEnvironmentProviderId.constructor-impl(Devcontainers.INSTANCE.getPluginId-NE1ku3Q());

    public DevcontainerToolboxAgents(@NotNull DevcontainersConnectionFactory devcontainersConnectionFactory, @NotNull GatewayServices gatewayServices, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)devcontainersConnectionFactory, (String)"devcontainersConnectionFactory");
        Intrinsics.checkNotNullParameter((Object)gatewayServices, (String)"gatewayServices");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.devcontainersConnectionFactory = devcontainersConnectionFactory;
        this.gatewayServices = gatewayServices;
        this.coroutineScope = coroutineScope;
        this.states = new ConcurrentHashMap();
        this.devcontainerEnvironments = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StateFlow<State> launchToolboxAgent(@NotNull Devcontainer devcontainer) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)devcontainer, (String)"devcontainer");
        ConcurrentMap concurrentMap = this.devcontainerEnvironments;
        String key$iv = devcontainer.getId();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            void $this$getOrPut$iv2;
            boolean bl = false;
            String string = Devcontainers.INSTANCE.getPluginId-NE1ku3Q();
            CoroutineScope coroutineScope = this.coroutineScope;
            String string2 = providerId;
            Object object2 = this.states;
            String key$iv2 = devcontainer.getId();
            boolean $i$f$getOrPut2 = false;
            Object object3 = $this$getOrPut$iv2.get(key$iv2);
            if (object3 == null) {
                boolean bl2 = false;
                MutableStateFlow default$iv = StateFlowKt.MutableStateFlow((Object)State.Initial.INSTANCE);
                boolean bl3 = false;
                object3 = $this$getOrPut$iv2.putIfAbsent(key$iv2, default$iv);
                if (object3 == null) {
                    object3 = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object3, (String)"getOrPut(...)");
            MutableStateFlow mutableStateFlow = (MutableStateFlow)object3;
            DevcontainersConnectionFactory devcontainersConnectionFactory = this.devcontainersConnectionFactory;
            object2 = this.gatewayServices.getClientHandleManager();
            ToolToConnectionAssociationManager toolToConnectionAssociationManager = this.gatewayServices.getToolToConnectionAssociationManager();
            ClientConnectionTracker clientConnectionTracker = this.gatewayServices.getClientConnectionTracker();
            DevcontainerEnvironment default$iv = new DevcontainerEnvironment(string, coroutineScope, devcontainersConnectionFactory, string2, devcontainer, mutableStateFlow, (JBClientConnectionHandleManager)object2, clientConnectionTracker, toolToConnectionAssociationManager, null);
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        DevcontainerEnvironment devcontainerEnvironment = (DevcontainerEnvironment)object;
        return (StateFlow)devcontainerEnvironment.getToolboxAgentStateFlow$devcontainers();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StateFlow<State> getToolboxAgentState(@NotNull Devcontainer devcontainer) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)devcontainer, (String)"devcontainer");
        ConcurrentMap concurrentMap = this.states;
        String key$iv = devcontainer.getId();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            MutableStateFlow default$iv = StateFlowKt.MutableStateFlow((Object)State.Initial.INSTANCE);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return FlowKt.asStateFlow((MutableStateFlow)((MutableStateFlow)object));
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static sealed interface State {

        public static final class Deploying
        implements State {
            @NotNull
            private final Flow<String> line;

            public Deploying(@NotNull Flow<String> line) {
                Intrinsics.checkNotNullParameter(line, (String)"line");
                this.line = line;
            }

            @NotNull
            public String toString() {
                return "Deploying(line=" + this.line + ")";
            }

            public int hashCode() {
                return this.line.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Deploying)) {
                    return false;
                }
                Deploying deploying = (Deploying)other;
                return Intrinsics.areEqual(this.line, deploying.line);
            }
        }

        public static final class Initial
        implements State {
            @NotNull
            public static final Initial INSTANCE = new Initial();

            private Initial() {
            }

            @NotNull
            public String toString() {
                return "Initial";
            }

            public int hashCode() {
                return 1617542494;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Initial)) {
                    return false;
                }
                Initial cfr_ignored_0 = (Initial)other;
                return true;
            }
        }

        public static final class Running
        implements State {
            @NotNull
            private final StateFlow<RawInterfaces> rawInterfaces;

            public Running(@NotNull StateFlow<? extends RawInterfaces> rawInterfaces) {
                Intrinsics.checkNotNullParameter(rawInterfaces, (String)"rawInterfaces");
                this.rawInterfaces = rawInterfaces;
            }

            @NotNull
            public final StateFlow<RawInterfaces> getRawInterfaces() {
                return this.rawInterfaces;
            }

            @NotNull
            public String toString() {
                return "Running(rawInterfaces=" + this.rawInterfaces + ")";
            }

            public int hashCode() {
                return this.rawInterfaces.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Running)) {
                    return false;
                }
                Running running = (Running)other;
                return Intrinsics.areEqual(this.rawInterfaces, running.rawInterfaces);
            }
        }

        public static final class Stopped
        implements State {
            @NotNull
            public static final Stopped INSTANCE = new Stopped();

            private Stopped() {
            }

            @NotNull
            public String toString() {
                return "Stopped";
            }

            public int hashCode() {
                return 2079848423;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Stopped)) {
                    return false;
                }
                Stopped cfr_ignored_0 = (Stopped)other;
                return true;
            }
        }
    }
}

