/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.desktop.clipboard;

import com.jetbrains.toolbox.desktop.clipboard.Attachment;
import com.jetbrains.toolbox.desktop.clipboard.AttachmentType;
import com.jetbrains.toolbox.desktop.clipboard.ClipboardContent;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClipboardContentImpl
implements ClipboardContent {
    @NotNull
    private final Map<AttachmentType<?>, Attachment<?>> entries;

    public ClipboardContentImpl(@NotNull Map<AttachmentType<?>, ? extends Attachment<?>> entries2) {
        Intrinsics.checkNotNullParameter(entries2, (String)"entries");
        this.entries = entries2;
    }

    @NotNull
    public final Map<AttachmentType<?>, Attachment<?>> getEntries() {
        return this.entries;
    }

    @Override
    @Nullable
    public <T> T getData(@NotNull AttachmentType<T> type2) {
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Attachment<T> attachment = this.getAttachment(type2);
        return (T)(attachment != null ? attachment.getValue() : null);
    }

    @Override
    @Nullable
    public <T> Attachment<T> getAttachment(@NotNull AttachmentType<T> type2) {
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        return this.entries.get(type2);
    }
}

