/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.desktop;

import com.jetbrains.toolbox.desktop.Point;
import com.jetbrains.toolbox.desktop.Size;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Rect {
    private final int left;
    private final int top;
    private final int right;
    private final int bottom;

    public Rect(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getTop() {
        return this.top;
    }

    public final int getRight() {
        return this.right;
    }

    public final int getBottom() {
        return this.bottom;
    }

    public Rect(@NotNull Point origin, @NotNull Size size) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this(origin.getX(), origin.getY(), origin.getX() + size.getWidth(), origin.getY() + size.getHeight());
    }

    public final int getMaxX() {
        return Math.max(this.left, this.right);
    }

    public final int getMaxY() {
        return Math.max(this.top, this.bottom);
    }

    public final int getWidth() {
        return this.right - this.left;
    }

    public final int getHeight() {
        return this.bottom - this.top;
    }

    @NotNull
    public final Size getSize() {
        return new Size(this.getWidth(), this.getHeight());
    }

    public final int component1() {
        return this.left;
    }

    public final int component2() {
        return this.top;
    }

    public final int component3() {
        return this.right;
    }

    public final int component4() {
        return this.bottom;
    }

    @NotNull
    public final Rect copy(int left, int top, int right, int bottom) {
        return new Rect(left, top, right, bottom);
    }

    public static /* synthetic */ Rect copy$default(Rect rect, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = rect.left;
        }
        if ((n5 & 2) != 0) {
            n2 = rect.top;
        }
        if ((n5 & 4) != 0) {
            n3 = rect.right;
        }
        if ((n5 & 8) != 0) {
            n4 = rect.bottom;
        }
        return rect.copy(n, n2, n3, n4);
    }

    @NotNull
    public String toString() {
        return "Rect(left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.left);
        result2 = result2 * 31 + Integer.hashCode(this.top);
        result2 = result2 * 31 + Integer.hashCode(this.right);
        result2 = result2 * 31 + Integer.hashCode(this.bottom);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rect)) {
            return false;
        }
        Rect rect = (Rect)other;
        if (this.left != rect.left) {
            return false;
        }
        if (this.top != rect.top) {
            return false;
        }
        if (this.right != rect.right) {
            return false;
        }
        return this.bottom == rect.bottom;
    }
}

