/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.desktop;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.macos.ThreadingKt;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class EdtKt {
    public static final boolean isEnvironmentHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static final void invokeLaterIfNeeded(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        if (EdtKt.isEnvironmentHeadless()) {
            Logger.INSTANCE.warn("Skipping action due to headless environment");
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            action2.invoke();
        } else {
            SwingUtilities.invokeLater(() -> EdtKt.invokeLaterIfNeeded$lambda$0(action2));
        }
    }

    public static final void adjustEdtPriority() {
        SwingUtilities.invokeLater(EdtKt::adjustEdtPriority$lambda$0);
    }

    public static final void keepEventQueue(@NotNull CoroutineScope coroutineScope) {
        JFrame jFrame;
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        JFrame $this$keepEventQueue_u24lambda_u240 = jFrame = new JFrame();
        boolean bl = false;
        $this$keepEventQueue_u24lambda_u240.setDefaultCloseOperation(1);
        $this$keepEventQueue_u24lambda_u240.setSize(new Dimension(0, 0));
        $this$keepEventQueue_u24lambda_u240.setLocation(new Point(-1000000, -1000000));
        $this$keepEventQueue_u24lambda_u240.setVisible(false);
        JFrame frame = jFrame;
        JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> EdtKt.keepEventQueue$lambda$1(frame, arg_0));
    }

    private static final void invokeLaterIfNeeded$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void adjustEdtPriority$lambda$0() {
        if (OS.INSTANCE.isMac()) {
            ThreadingKt.macosRaiseThreadPriority();
        } else if (OS.INSTANCE.isWindows()) {
            Thread.currentThread().setPriority(10);
        }
    }

    private static final Unit keepEventQueue$lambda$1(JFrame $frame, Throwable it) {
        $frame.dispose();
        return Unit.INSTANCE;
    }
}

