/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.desktop;

import com.jetbrains.toolbox.desktop.Point;
import com.jetbrains.toolbox.desktop.Rect;
import com.jetbrains.toolbox.desktop.ScreenFrames;
import com.jetbrains.toolbox.desktop.Size;
import com.jetbrains.toolbox.desktop.WindowsShowPoint;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\ndisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 display.kt\ncom/jetbrains/toolbox/desktop/DisplayKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n11561#2:98\n11896#2,3:99\n295#3,2:102\n1#4:104\n*S KotlinDebug\n*F\n+ 1 display.kt\ncom/jetbrains/toolbox/desktop/DisplayKt\n*L\n26#1:98\n26#1:99,3\n30#1:102,2\n*E\n"})
public final class DisplayKt {
    @Nullable
    public static final Rect calcScreenRectForPoint(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        ScreenFrames screenFrames = DisplayKt.getScreenFrames(point);
        return screenFrames != null ? screenFrames.getVisibleScreenFrame() : null;
    }

    private static final WindowsShowPoint getWindowsShowPoint(ScreenFrames $this$getWindowsShowPoint) {
        return $this$getWindowsShowPoint.getVisibleScreenFrame().getTop() > $this$getWindowsShowPoint.getScreenFrame().getTop() ? WindowsShowPoint.TOP_RIGHT : ($this$getWindowsShowPoint.getVisibleScreenFrame().getBottom() < $this$getWindowsShowPoint.getScreenFrame().getBottom() && $this$getWindowsShowPoint.getVisibleScreenFrame().getRight() < $this$getWindowsShowPoint.getScreenFrame().getRight() ? WindowsShowPoint.BOTTOM_RIGHT : ($this$getWindowsShowPoint.getVisibleScreenFrame().getLeft() > $this$getWindowsShowPoint.getScreenFrame().getLeft() ? WindowsShowPoint.BOTTOM_LEFT : WindowsShowPoint.BOTTOM_RIGHT));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<GraphicsConfiguration> getAllScreens() {
        void var3_3;
        void $this$mapTo$iv$iv;
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsDeviceArray, (String)"getScreenDevices(...)");
        Object[] $this$map$iv = graphicsDeviceArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GraphicsDevice graphicsDevice = (GraphicsDevice)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDefaultConfiguration());
        }
        return (List)var3_3;
    }

    private static final GraphicsConfiguration getScreenContainingPoint(List<? extends GraphicsConfiguration> allScreens, Point point) {
        GraphicsConfiguration graphicsConfiguration;
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = allScreens;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GraphicsConfiguration gc = (GraphicsConfiguration)element$iv;
                boolean bl = false;
                if (!gc.getBounds().contains(point.getX(), point.getY())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((graphicsConfiguration = (GraphicsConfiguration)v0) == null) {
            graphicsConfiguration = (GraphicsConfiguration)CollectionsKt.first(allScreens);
        }
        return graphicsConfiguration;
    }

    @Nullable
    public static final ScreenFrames getScreenFrames(@NotNull Point location2) {
        ScreenFrames screenFrames;
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        try {
            Rect bounds;
            List<GraphicsConfiguration> allScreens = DisplayKt.getAllScreens();
            Logger.INSTANCE.info("Available screens " + CollectionsKt.joinToString$default((Iterable)allScreens, null, null, null, (int)0, null, DisplayKt::getScreenFrames$lambda$0, (int)31, null));
            GraphicsConfiguration graphicsConfiguration = DisplayKt.getScreenContainingPoint(allScreens, location2);
            Object object = graphicsConfiguration;
            if (object != null && (object = ((GraphicsConfiguration)object).getBounds()) != null) {
                Object it = object;
                boolean bl = false;
                v1 = new Rect(new Point(((Rectangle)it).x, ((Rectangle)it).y), new Size(((Rectangle)it).width, ((Rectangle)it).height));
            } else {
                v1 = bounds = null;
            }
            if (bounds == null) {
                return null;
            }
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            Insets insets2 = insets;
            Rect visibleBounds = new Rect(bounds.getLeft() + insets2.left, bounds.getTop() + insets2.top, bounds.getRight() - insets2.right, bounds.getBottom() - insets2.bottom);
            Logger.INSTANCE.info("Display size " + bounds + " with insets " + insets2 + " for " + location2);
            screenFrames = new ScreenFrames(bounds, visibleBounds);
        }
        catch (Throwable t2) {
            Logger.INSTANCE.warn(t2, "Cannot get display size");
            screenFrames = null;
        }
        return screenFrames;
    }

    @NotNull
    public static final Point getShowPointByInsets() {
        Object object;
        block5: {
            block4: {
                ScreenFrames screenFrames;
                Point point = DisplayKt.getMouseLocation();
                if (point == null) {
                    point = Point.Companion.getZero();
                }
                if ((object = (screenFrames = DisplayKt.getScreenFrames(point))) == null) break block4;
                ScreenFrames frames = object;
                boolean bl = false;
                WindowsShowPoint showPoint = DisplayKt.getWindowsShowPoint(frames);
                Logger.INSTANCE.debug(() -> DisplayKt.getShowPointByInsets$lambda$0$0(showPoint));
                Point point2 = showPoint.getOnScreen(frames);
                object = point2;
                if (point2 != null) break block5;
            }
            object = Point.Companion.getZero();
        }
        return object;
    }

    @Nullable
    public static final Point getMouseLocation() {
        Point point;
        try {
            Point point2;
            Object object = MouseInfo.getPointerInfo();
            if (object != null && (object = ((PointerInfo)object).getLocation()) != null) {
                Object it = object;
                boolean bl = false;
                point2 = new Point(((java.awt.Point)it).x, ((java.awt.Point)it).y);
            } else {
                point2 = null;
            }
            point = point2;
        }
        catch (Throwable throwable) {
            point = null;
        }
        return point;
    }

    private static final CharSequence getScreenFrames$lambda$0(GraphicsConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getBounds().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String getShowPointByInsets$lambda$0$0(WindowsShowPoint $showPoint) {
        return "Tray icon show point: " + $showPoint;
    }
}

