/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.security;

import java.security.MessageDigest;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class CloningMessageDigest {
    @NotNull
    private final String type;
    private final MessageDigest instance;

    public CloningMessageDigest(@NotNull String type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.type = type2;
        this.instance = MessageDigest.getInstance(this.type);
    }

    @NotNull
    public final MessageDigest getValue(@Nullable Void nothing, @NotNull KProperty<?> property) {
        MessageDigest messageDigest;
        Intrinsics.checkNotNullParameter(property, (String)"property");
        try {
            Object object = this.instance.clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.security.MessageDigest");
            messageDigest = (MessageDigest)object;
        }
        catch (Throwable t2) {
            Logger.INSTANCE.info(t2, "Cannot clone hasher for " + this.type);
            MessageDigest messageDigest2 = MessageDigest.getInstance(this.type);
            Intrinsics.checkNotNull((Object)messageDigest2);
            messageDigest = messageDigest2;
        }
        return messageDigest;
    }
}

