/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.io;

import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.common.io.FileSize;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.FileMetadata;
import okio.FileSystem;
import okio.ForwardingFileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nFileSystemExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemExt.kt\ncom/jetbrains/toolbox/common/io/FileSystemExtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1#2:146\n669#3,11:147\n1563#3:158\n1634#3,3:159\n*S KotlinDebug\n*F\n+ 1 FileSystemExt.kt\ncom/jetbrains/toolbox/common/io/FileSystemExtKt\n*L\n63#1:147,11\n93#1:158\n93#1:159,3\n*E\n"})
public final class FileSystemExtKt {
    public static final boolean isSystem(@NotNull FileSystem $this$isSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$isSystem, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isSystem, (Object)FileSystem.SYSTEM) || $this$isSystem instanceof ForwardingFileSystem && FileSystemExtKt.isSystem(((ForwardingFileSystem)$this$isSystem).delegate());
    }

    public static final boolean isWritable(@NotNull FileSystem $this$isWritable, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)$this$isWritable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        FileSystemExtKt.requireSystemFS($this$isWritable, "isWritable");
        return Files.isWritable(file.toNioPath());
    }

    public static final boolean isReadable(@NotNull FileSystem $this$isReadable, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)$this$isReadable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        FileSystemExtKt.requireSystemFS($this$isReadable, "isReadable");
        return Files.isReadable(file.toNioPath());
    }

    public static final boolean isExecutable(@NotNull FileSystem $this$isExecutable, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)$this$isExecutable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        FileSystemExtKt.requireSystemFS($this$isExecutable, "isExecutable");
        return Files.isExecutable(file.toNioPath());
    }

    public static final void setReadable(@NotNull FileSystem $this$setReadable, @NotNull Path file, boolean readable, boolean ownerOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$setReadable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        FileSystemExtKt.requireSystemFS($this$setReadable, "setReadable");
        file.toFile().setReadable(readable, ownerOnly);
    }

    public static final void setWritable(@NotNull FileSystem $this$setWritable, @NotNull Path file, boolean writable, boolean ownerOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$setWritable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        FileSystemExtKt.requireSystemFS($this$setWritable, "setWritable");
        file.toFile().setWritable(writable, ownerOnly);
    }

    public static final void setExecutable(@NotNull FileSystem $this$setExecutable, @NotNull Path file, boolean executable, boolean ownerOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$setExecutable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        FileSystemExtKt.requireSystemFS($this$setExecutable, "setExecutable");
        file.toFile().setExecutable(executable, ownerOnly);
    }

    public static /* synthetic */ void setExecutable$default(FileSystem fileSystem, Path path2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        FileSystemExtKt.setExecutable(fileSystem, path2, bl, bl2);
    }

    private static final void requireSystemFS(FileSystem $this$requireSystemFS, String methodName) {
        if (!FileSystemExtKt.isSystem($this$requireSystemFS)) {
            boolean bl = false;
            String string = methodName + "(..) extension supports only FileSystem.SYSTEM";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Nullable
    public static final Path getMacAppUnderDirectory(@NotNull FileSystem $this$getMacAppUnderDirectory, @NotNull Path directory) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)$this$getMacAppUnderDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        if (StringsKt.endsWith$default((String)directory.name(), (String)".app", (boolean)false, (int)2, null)) {
            return directory;
        }
        List list2 = $this$getMacAppUnderDirectory.listOrNull(directory);
        if (list2 != null) {
            Object v1;
            block5: {
                Iterable $this$singleOrNull$iv = list2;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    if (!(StringsKt.endsWith$default((String)it.name(), (String)".app", (boolean)false, (int)2, null) && $this$getMacAppUnderDirectory.metadata(it).isDirectory())) continue;
                    if (found$iv) {
                        v1 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            path2 = v1;
        } else {
            path2 = null;
        }
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    public static final long calculateSizeRecursively(@NotNull FileSystem $this$calculateSizeRecursively, @NotNull Path path2) {
        Collection<FileSize> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$calculateSizeRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        FileMetadata metadata2 = $this$calculateSizeRecursively.metadataOrNull(path2);
        if (metadata2 == null) {
            Logger.INSTANCE.debug(() -> FileSystemExtKt.calculateSizeRecursively$lambda$0(path2));
            return FileSystemExtKt.getBytes(0);
        }
        if (!metadata2.isDirectory() && !metadata2.isRegularFile()) {
            Logger.INSTANCE.debug(() -> FileSystemExtKt.calculateSizeRecursively$lambda$1(path2));
            return FileSystemExtKt.getBytes(0);
        }
        Long l2 = metadata2.getSize();
        if (l2 != null) {
            l = FileSystemExtKt.getBytes(l2);
        } else {
            FileSystem $this$calculateSizeRecursively_u24lambda_u242 = $this$calculateSizeRecursively;
            boolean bl = false;
            Logger.INSTANCE.debug(() -> FileSystemExtKt.calculateSizeRecursively$lambda$2$0(path2));
            l = FileSystemExtKt.getBytes(0);
        }
        long ownSize = l;
        List list2 = $this$calculateSizeRecursively.listOrNull(path2);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List children = list2;
        Iterable iterable = children;
        long l3 = ownSize;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path3 = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FileSize.box-impl(FileSystemExtKt.calculateSizeRecursively($this$calculateSizeRecursively, (Path)it)));
        }
        collection = (List)destination$iv$iv;
        return FileSize.plus-vubMv80(l3, FileSystemExtKt.sum((Iterable<FileSize>)collection));
    }

    public static final long getBytes(long $this$bytes) {
        return FileSize.constructor-impl($this$bytes);
    }

    public static final long getBytes(int $this$bytes) {
        return FileSize.constructor-impl($this$bytes);
    }

    /*
     * WARNING - void declaration
     */
    public static final long sum(@NotNull Iterable<FileSize> $this$sum) {
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        Iterable<FileSize> iterable = $this$sum;
        long l = 0L;
        for (FileSize fileSize : iterable) {
            void it;
            long l2 = fileSize.unbox-impl();
            long l3 = l;
            boolean bl = false;
            void var11_8 = it;
            l = l3 + var11_8;
        }
        return FileSize.constructor-impl(l);
    }

    public static final long orZero-Re21GCo(@Nullable FileSize $this$orZero_u2dRe21GCo) {
        FileSize fileSize = $this$orZero_u2dRe21GCo;
        return fileSize != null ? fileSize.unbox-impl() : FileSize.Companion.getZERO-WN0b6rc();
    }

    @Nullable
    public static final Path canonicalizeOrNull(@NotNull FileSystem $this$canonicalizeOrNull, @NotNull Path path2) {
        Path path3;
        Intrinsics.checkNotNullParameter((Object)$this$canonicalizeOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            path3 = !$this$canonicalizeOrNull.exists(path2) ? null : $this$canonicalizeOrNull.canonicalize(path2);
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Failed to canonicalize " + path2);
            path3 = null;
        }
        return path3;
    }

    private static final String calculateSizeRecursively$lambda$0(Path $path) {
        return "Failed to get metadata for " + $path + ", assuming zero size";
    }

    private static final String calculateSizeRecursively$lambda$1(Path $path) {
        return $path + " is neither a directory nor a regular file, assuming zero size";
    }

    private static final String calculateSizeRecursively$lambda$2$0(Path $path) {
        return "Failed to get size for " + $path + ", assuming zero size";
    }
}

