/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.io;

import com.intellij.util.io.Compressor;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class CompressorExtensionsKt {
    public static final void addAllFromZip(@NotNull Compressor $this$addAllFromZip, @NotNull Path zipPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$addAllFromZip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zipPath, (String)"zipPath");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        File file = zipPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File file2 = file;
        CompressorExtensionsKt.addAllFromZip($this$addAllFromZip, new FileInputStream(file2), prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addAllFromZip(@NotNull Compressor $this$addAllFromZip, @NotNull InputStream inputStream, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$addAllFromZip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Closeable closeable = new ZipInputStream(inputStream);
        Throwable throwable = null;
        try {
            ZipInputStream zipStream = (ZipInputStream)closeable;
            boolean bl = false;
            ZipEntry entry = zipStream.getNextEntry();
            while (entry != null) {
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                char[] cArray = new char[]{'/', '\\'};
                String path2 = StringsKt.trim((String)string, (char[])cArray);
                if (StringsKt.contains$default((CharSequence)path2, (CharSequence)"..", (boolean)false, (int)2, null)) {
                    Logger.INSTANCE.warn("Suspicious zip entry name: " + path2);
                    continue;
                }
                String[] stringArray = new String[]{path2};
                String newEntryName = StringsKt.replace$default((String)((Object)Path.of(prefix, stringArray)).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
                long entryTime = entry.getLastModifiedTime().toMillis();
                if (entry.isDirectory()) {
                    $this$addAllFromZip.addDirectory(newEntryName, entryTime);
                } else {
                    $this$addAllFromZip.addFile(newEntryName, zipStream, entryTime);
                }
                entry = zipStream.getNextEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

