/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.formatting;

import java.util.Arrays;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class HumanMemorySizeKt {
    @NotNull
    private static final List<String> suffixesWithSpace;
    @NotNull
    private static final List<String> suffixesWithoutSpace;

    @NotNull
    public static final String humanFileSize(long bytes2, int precision) {
        return HumanMemorySizeKt.humanMemorySize$default(bytes2, precision, false, 4, null);
    }

    public static /* synthetic */ String humanFileSize$default(long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return HumanMemorySizeKt.humanFileSize(l, n);
    }

    @NotNull
    public static final String humanMemorySize(double volume, int precision, boolean withSpace) {
        double size = volume;
        List<String> units = withSpace ? suffixesWithSpace : suffixesWithoutSpace;
        for (String unit : units) {
            if (size < 1024.0) {
                String string = "%." + precision + "f" + unit;
                Object[] objectArray = new Object[]{size};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                return string2;
            }
            size /= (double)1024;
        }
        String string = "%." + precision + "f";
        Object[] objectArray = new Object[]{size};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3 + (withSpace ? " TiB" : "T");
    }

    public static /* synthetic */ String humanMemorySize$default(double d, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return HumanMemorySizeKt.humanMemorySize(d, n, bl);
    }

    static {
        Object[] objectArray = new String[]{" bytes", " KiB", " MiB", " GiB"};
        suffixesWithSpace = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"", "k", "M", "G"};
        suffixesWithoutSpace = CollectionsKt.listOf((Object[])objectArray);
    }
}

