/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.extensions;

import java.util.Iterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class NodeListExtensions {
    @NotNull
    public static final NodeListExtensions INSTANCE = new NodeListExtensions();

    private NodeListExtensions() {
    }

    @NotNull
    public final Iterable<Node> toIterable(@NotNull NodeList $this$toIterable) {
        Intrinsics.checkNotNullParameter((Object)$this$toIterable, (String)"<this>");
        return new NodeListIterable($this$toIterable);
    }

    private static final class NodeListIterable
    implements Iterable<Node>,
    KMappedMarker {
        @NotNull
        private final NodeList nodeList;

        public NodeListIterable(@NotNull NodeList nodeList) {
            Intrinsics.checkNotNullParameter((Object)nodeList, (String)"nodeList");
            this.nodeList = nodeList;
        }

        @Override
        @NotNull
        public Iterator<Node> iterator() {
            return new NodeListIterator(this.nodeList);
        }

        private static final class NodeListIterator
        implements Iterator<Node>,
        KMappedMarker {
            @NotNull
            private final NodeList nodeList;
            private int currIndex;

            public NodeListIterator(@NotNull NodeList nodeList) {
                Intrinsics.checkNotNullParameter((Object)nodeList, (String)"nodeList");
                this.nodeList = nodeList;
            }

            @Override
            public boolean hasNext() {
                return this.currIndex < this.nodeList.getLength();
            }

            @Override
            @NotNull
            public Node next() {
                int n = this.currIndex;
                this.currIndex = n + 1;
                Node node2 = this.nodeList.item(n);
                Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"item(...)");
                return node2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        }
    }
}

