/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common;

import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class Win32ArgumentHelper {
    @NotNull
    public static final Win32ArgumentHelper INSTANCE = new Win32ArgumentHelper();
    @NotNull
    private static final Regex backslashesRegex = new Regex("\\\\+(?=\"|$)");

    private Win32ArgumentHelper() {
    }

    private final boolean containsCharsToBeQuoted(String str) {
        return StringsKt.contains$default((CharSequence)str, (char)' ', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)str, (char)'\"', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)str, (char)'\n', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)str, (char)'\t', (boolean)false, (int)2, null);
    }

    @NotNull
    public final String quoteArgument(@NotNull String arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        if (((CharSequence)arg).length() == 0) {
            return "\"\"";
        }
        if (!this.containsCharsToBeQuoted(arg)) {
            return arg;
        }
        CharSequence charSequence = arg;
        Regex regex = backslashesRegex;
        Function1 function1 = Win32ArgumentHelper::quoteArgument$lambda$0;
        String result2 = StringsKt.replace$default((String)regex.replace(charSequence, function1), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
        return "\"" + result2 + "\"";
    }

    private static final CharSequence quoteArgument$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.repeat((CharSequence)it.getValue(), (int)2);
    }
}

