/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common;

import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.internal.PluginGeneratedSerialDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
public final class TransitionEvent<State, Event> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final State from;
    @NotNull
    private final State to;
    @NotNull
    private final Event event;
    @JvmField
    @NotNull
    private static final SerialDescriptor $cachedDescriptor;

    public TransitionEvent(@NotNull State from, @NotNull State to, @NotNull Event event) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        Intrinsics.checkNotNullParameter(event, (String)"event");
        this.from = from;
        this.to = to;
        this.event = event;
    }

    @NotNull
    public final State getFrom() {
        return this.from;
    }

    @NotNull
    public final State getTo() {
        return this.to;
    }

    @NotNull
    public final Event getEvent() {
        return this.event;
    }

    @NotNull
    public final State component1() {
        return this.from;
    }

    @NotNull
    public final State component2() {
        return this.to;
    }

    @NotNull
    public final Event component3() {
        return this.event;
    }

    @NotNull
    public String toString() {
        return "TransitionEvent(from=" + this.from + ", to=" + this.to + ", event=" + this.event + ")";
    }

    public int hashCode() {
        int result2 = this.from.hashCode();
        result2 = result2 * 31 + this.to.hashCode();
        result2 = result2 * 31 + this.event.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TransitionEvent)) {
            return false;
        }
        TransitionEvent transitionEvent = (TransitionEvent)other;
        if (!Intrinsics.areEqual(this.from, transitionEvent.from)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.to, transitionEvent.to)) {
            return false;
        }
        return Intrinsics.areEqual(this.event, transitionEvent.event);
    }

    static {
        PluginGeneratedSerialDescriptor pluginGeneratedSerialDescriptor = new PluginGeneratedSerialDescriptor("com.jetbrains.toolbox.common.TransitionEvent", null, 3);
        pluginGeneratedSerialDescriptor.addElement("from", false);
        pluginGeneratedSerialDescriptor.addElement("to", false);
        pluginGeneratedSerialDescriptor.addElement("event", false);
        $cachedDescriptor = (SerialDescriptor)pluginGeneratedSerialDescriptor;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

