/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.common.Progress;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProgressState {
    @NotNull
    private final LocalizableString title;
    @NotNull
    private final Progress.ProgressType type;
    private final long totalSteps;
    private final boolean isCancelable;
    private final boolean isCanceled;
    @Nullable
    private final LocalizableString error;
    private final boolean isFinished;

    public ProgressState(@NotNull LocalizableString title2, @NotNull Progress.ProgressType type2, long totalSteps, boolean isCancelable, boolean isCanceled, @Nullable LocalizableString error2, boolean isFinished) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.title = title2;
        this.type = type2;
        this.totalSteps = totalSteps;
        this.isCancelable = isCancelable;
        this.isCanceled = isCanceled;
        this.error = error2;
        this.isFinished = isFinished;
    }

    public /* synthetic */ ProgressState(LocalizableString localizableString, Progress.ProgressType progressType, long l, boolean bl, boolean bl2, LocalizableString localizableString2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            progressType = Progress.ProgressType.NORMAL;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            localizableString2 = null;
        }
        if ((n & 0x40) != 0) {
            bl3 = false;
        }
        this(localizableString, progressType, l, bl, bl2, localizableString2, bl3);
    }

    @NotNull
    public final LocalizableString getTitle() {
        return this.title;
    }

    @NotNull
    public final Progress.ProgressType getType() {
        return this.type;
    }

    public final long getTotalSteps() {
        return this.totalSteps;
    }

    public final boolean isCancelable() {
        return this.isCancelable;
    }

    public final boolean isCanceled() {
        return this.isCanceled;
    }

    @Nullable
    public final LocalizableString getError() {
        return this.error;
    }

    public final boolean isFinished() {
        return this.isFinished;
    }

    @NotNull
    public final ProgressState copy(@NotNull LocalizableString title2, @NotNull Progress.ProgressType type2, long totalSteps, boolean isCancelable, boolean isCanceled, @Nullable LocalizableString error2, boolean isFinished) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        return new ProgressState(title2, type2, totalSteps, isCancelable, isCanceled, error2, isFinished);
    }

    public static /* synthetic */ ProgressState copy$default(ProgressState progressState, LocalizableString localizableString, Progress.ProgressType progressType, long l, boolean bl, boolean bl2, LocalizableString localizableString2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            localizableString = progressState.title;
        }
        if ((n & 2) != 0) {
            progressType = progressState.type;
        }
        if ((n & 4) != 0) {
            l = progressState.totalSteps;
        }
        if ((n & 8) != 0) {
            bl = progressState.isCancelable;
        }
        if ((n & 0x10) != 0) {
            bl2 = progressState.isCanceled;
        }
        if ((n & 0x20) != 0) {
            localizableString2 = progressState.error;
        }
        if ((n & 0x40) != 0) {
            bl3 = progressState.isFinished;
        }
        return progressState.copy(localizableString, progressType, l, bl, bl2, localizableString2, bl3);
    }

    @NotNull
    public String toString() {
        return "ProgressState(title=" + this.title + ", type=" + this.type + ", totalSteps=" + this.totalSteps + ", isCancelable=" + this.isCancelable + ", isCanceled=" + this.isCanceled + ", error=" + this.error + ", isFinished=" + this.isFinished + ")";
    }

    public int hashCode() {
        int result2 = this.title.hashCode();
        result2 = result2 * 31 + this.type.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.totalSteps);
        result2 = result2 * 31 + Boolean.hashCode(this.isCancelable);
        result2 = result2 * 31 + Boolean.hashCode(this.isCanceled);
        result2 = result2 * 31 + (this.error == null ? 0 : this.error.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.isFinished);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProgressState)) {
            return false;
        }
        ProgressState progressState = (ProgressState)other;
        if (!Intrinsics.areEqual((Object)this.title, (Object)progressState.title)) {
            return false;
        }
        if (this.type != progressState.type) {
            return false;
        }
        if (this.totalSteps != progressState.totalSteps) {
            return false;
        }
        if (this.isCancelable != progressState.isCancelable) {
            return false;
        }
        if (this.isCanceled != progressState.isCanceled) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.error, (Object)progressState.error)) {
            return false;
        }
        return this.isFinished == progressState.isFinished;
    }
}

