/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common;

import com.jetbrains.toolbox.common.InvalidPortRangeException;
import com.jetbrains.toolbox.common.PortOutOfRangeException;
import com.jetbrains.toolbox.common.PortRange$;
import java.util.Iterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntRange;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
public final class PortRange
implements Iterable<Integer>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int start;
    private final int end;

    public PortRange(int start2, int end) {
        this.start = start2;
        this.end = end;
        if (this.start < 1 || this.end > 65535) {
            throw new PortOutOfRangeException();
        }
        if (this.start > this.end) {
            throw new InvalidPortRangeException();
        }
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public int hashCode() {
        return this.start * 31 + this.end;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof PortRange)) {
            return false;
        }
        return this.start == ((PortRange)other).start && this.end == ((PortRange)other).end;
    }

    @NotNull
    public String toString() {
        return "PortRange(" + this.start + ", " + this.end + ")";
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return (Iterator)new IntRange(this.start, this.end).iterator();
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$common(PortRange self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        output2.encodeIntElement(serialDesc, 0, self.start);
        output2.encodeIntElement(serialDesc, 1, self.end);
    }

    public /* synthetic */ PortRange(int seen0, int start2, int end, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.start = start2;
        this.end = end;
        if (this.start < 1 || this.end > 65535) {
            throw new PortOutOfRangeException();
        }
        if (this.start > this.end) {
            throw new InvalidPortRangeException();
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<PortRange> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

