/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nParseDesktopFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParseDesktopFile.kt\ncom/jetbrains/toolbox/common/ParseDesktopFileKt\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n*L\n1#1,44:1\n66#2:45\n52#2,4:47\n60#2,10:52\n56#2,3:62\n71#2,3:65\n67#3:46\n68#3:51\n*S KotlinDebug\n*F\n+ 1 ParseDesktopFile.kt\ncom/jetbrains/toolbox/common/ParseDesktopFileKt\n*L\n23#1:45\n23#1:47,4\n23#1:52,10\n23#1:62,3\n23#1:65,3\n23#1:46\n23#1:51\n*E\n"})
public final class ParseDesktopFileKt {
    @NotNull
    private static final Regex desktopFileSectionRegex = new Regex("^\\[(?>(?![\\[\\]])[\\x00-\\x7F])*]$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static final Map<String, String> parseDesktopFile(@NotNull FileSystem $this$parseDesktopFile, @NotNull Path path2) {
        Unit unit;
        Throwable thrown$iv$iv;
        Map map2;
        block19: {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)$this$parseDesktopFile, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Map $this$parseDesktopFile_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
            boolean bl = false;
            FileMetadata metadata2 = $this$parseDesktopFile.metadataOrNull(path2);
            if (metadata2 == null) {
                Logger.INSTANCE.debug("Skipping non-existent .desktop file '" + path2 + "'");
                return MapsKt.build((Map)map2);
            }
            Long size = metadata2.getSize();
            if (size == null) {
                Logger.INSTANCE.debug("Skipping .desktop file '" + path2 + "' of unknown size");
                return MapsKt.build((Map)map2);
            }
            if (size > 50000L) {
                Logger.INSTANCE.debug("Skipping suspiciously large desktop file '" + path2 + "' of size " + size);
                return MapsKt.build((Map)map2);
            }
            FileSystem fileSystem = $this$parseDesktopFile;
            Path file$iv = path2;
            bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSource $this$parseDesktopFile_u24lambda_u240_u240 = it$iv;
                boolean bl3 = false;
                while (!$this$parseDesktopFile_u24lambda_u240_u240.exhausted()) {
                    String line = $this$parseDesktopFile_u24lambda_u240_u240.readUtf8Line();
                    CharSequence charSequence = line;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null)) continue;
                    MatchResult match2 = desktopFileSectionRegex.matchEntire((CharSequence)line);
                    if (match2 != null) {
                        if (!Intrinsics.areEqual((Object)line, (Object)"[Desktop Entry]")) break;
                        continue;
                    }
                    char[] cArray = new char[]{'='};
                    List split = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)2, (int)2, null);
                    if (split.size() != 2) continue;
                    $this$parseDesktopFile_u24lambda_u240.put(split.get(0), split.get(1));
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    unit = null;
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block20: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block20;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        Unit result$iv$iv = unit;
        Throwable throwable = thrown$iv$iv;
        if (throwable == null) return MapsKt.build((Map)map2);
        throw throwable;
    }
}

