/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ai.chat.ui.widgets;

import androidx.compose.runtime.Composer;
import com.jetbrains.toolbox.ai.chat.ui.widgets.FunctionCallInfo;
import com.jetbrains.toolbox.common.ai.TextGenerationSpeed;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface MessageRosterWidget {

    public static final class AssistantCompletedWidget
    implements AssistantWidget {
        @NotNull
        private final String text;
        @NotNull
        private final TextGenerationSpeed generationSpeed;
        public static final int $stable = 8;

        public AssistantCompletedWidget(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
            this.generationSpeed = TextGenerationSpeed.Companion.getZERO();
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        @NotNull
        public TextGenerationSpeed getGenerationSpeed() {
            return this.generationSpeed;
        }

        @NotNull
        public String toString() {
            return "AssistantCompletedWidget(text=" + this.text + ")";
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AssistantCompletedWidget)) {
                return false;
            }
            AssistantCompletedWidget assistantCompletedWidget = (AssistantCompletedWidget)other;
            return Intrinsics.areEqual((Object)this.text, (Object)assistantCompletedWidget.text);
        }
    }

    public static final class AssistantInProgressWidget
    implements AssistantWidget {
        @NotNull
        private final String text;
        @NotNull
        private final TextGenerationSpeed generationSpeed;
        public static final int $stable = 8;

        public AssistantInProgressWidget(@NotNull String text2, @NotNull TextGenerationSpeed generationSpeed) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)generationSpeed, (String)"generationSpeed");
            this.text = text2;
            this.generationSpeed = generationSpeed;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        @NotNull
        public TextGenerationSpeed getGenerationSpeed() {
            return this.generationSpeed;
        }

        @NotNull
        public String toString() {
            return "AssistantInProgressWidget(text=" + this.text + ", generationSpeed=" + this.generationSpeed + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.generationSpeed.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AssistantInProgressWidget)) {
                return false;
            }
            AssistantInProgressWidget assistantInProgressWidget = (AssistantInProgressWidget)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)assistantInProgressWidget.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.generationSpeed, (Object)assistantInProgressWidget.generationSpeed);
        }
    }

    public static sealed interface AssistantWidget
    extends MessageRosterWidget
    permits AssistantCompletedWidget, AssistantInProgressWidget {
        @NotNull
        public String getText();

        @NotNull
        public TextGenerationSpeed getGenerationSpeed();
    }

    public static final class FunctionCallWidget
    implements MessageRosterWidget {
        @NotNull
        private final Map<String, FunctionCallInfo> callsInfo;
        public static final int $stable = 8;

        public FunctionCallWidget(@NotNull Map<String, FunctionCallInfo> callsInfo) {
            Intrinsics.checkNotNullParameter(callsInfo, (String)"callsInfo");
            this.callsInfo = callsInfo;
        }

        @NotNull
        public final Map<String, FunctionCallInfo> getCallsInfo() {
            return this.callsInfo;
        }

        @NotNull
        public final FunctionCallWidget copy(@NotNull Map<String, FunctionCallInfo> callsInfo) {
            Intrinsics.checkNotNullParameter(callsInfo, (String)"callsInfo");
            return new FunctionCallWidget(callsInfo);
        }

        @NotNull
        public String toString() {
            return "FunctionCallWidget(callsInfo=" + this.callsInfo + ")";
        }

        public int hashCode() {
            return ((Object)this.callsInfo).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FunctionCallWidget)) {
                return false;
            }
            FunctionCallWidget functionCallWidget = (FunctionCallWidget)other;
            return Intrinsics.areEqual(this.callsInfo, functionCallWidget.callsInfo);
        }
    }

    public static final class InteractiveRequestWidget
    implements MessageRosterWidget {
        @NotNull
        private final Function2<Composer, Integer, Unit> content;

        public InteractiveRequestWidget(@NotNull Function2<? super Composer, ? super Integer, Unit> content2) {
            Intrinsics.checkNotNullParameter(content2, (String)"content");
            this.content = content2;
        }

        @NotNull
        public final Function2<Composer, Integer, Unit> getContent() {
            return this.content;
        }

        @NotNull
        public String toString() {
            return "InteractiveRequestWidget(content=" + this.content + ")";
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InteractiveRequestWidget)) {
                return false;
            }
            InteractiveRequestWidget interactiveRequestWidget = (InteractiveRequestWidget)other;
            return Intrinsics.areEqual(this.content, interactiveRequestWidget.content);
        }
    }

    public static final class SystemWidget
    implements MessageRosterWidget {
        @NotNull
        private final String text;

        public SystemWidget(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
        }

        @NotNull
        public String toString() {
            return "SystemWidget(text=" + this.text + ")";
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SystemWidget)) {
                return false;
            }
            SystemWidget systemWidget = (SystemWidget)other;
            return Intrinsics.areEqual((Object)this.text, (Object)systemWidget.text);
        }
    }

    public static final class UserWidget
    implements MessageRosterWidget {
        @NotNull
        private final String text;

        public UserWidget(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public String toString() {
            return "UserWidget(text=" + this.text + ")";
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserWidget)) {
                return false;
            }
            UserWidget userWidget = (UserWidget)other;
            return Intrinsics.areEqual((Object)this.text, (Object)userWidget.text);
        }
    }
}

