/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts.space;

import com.jetbrains.toolbox.accounts.OAuthSecureToken;
import com.jetbrains.toolbox.accounts.RefreshConfigurationImpl;
import com.jetbrains.toolbox.accounts.SpaceAccount;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Token;
import com.jetbrains.toolbox.accounts.oauth.OAuthTokenRefresherImpl;
import com.jetbrains.toolbox.accounts.space.SpaceAccountConstants;
import com.jetbrains.toolbox.api.core.auth.ContentType;
import com.jetbrains.toolbox.api.core.auth.RefreshConfiguration;
import com.jetbrains.toolbox.network.BasicDownloadManager;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSpaceTokenRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceTokenRefresher.kt\ncom/jetbrains/toolbox/accounts/space/SpaceTokenRefresher\n+ 2 SpaceAccountConstants.kt\ncom/jetbrains/toolbox/accounts/space/SpaceAccountConstants\n*L\n1#1,41:1\n12#2,2:42\n12#2:44\n*S KotlinDebug\n*F\n+ 1 SpaceTokenRefresher.kt\ncom/jetbrains/toolbox/accounts/space/SpaceTokenRefresher\n*L\n25#1:42,2\n31#1:44\n*E\n"})
public final class SpaceTokenRefresher
extends OAuthTokenRefresherImpl<SpaceAccount, OAuthSecureToken> {
    @NotNull
    private final String appAuth;

    public SpaceTokenRefresher(@NotNull BasicDownloadManager downloadManager, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super("JetBrains Space", downloadManager, clock);
        Base64 base64 = (Base64)Base64.Default;
        SpaceAccountConstants this_$iv = SpaceAccountConstants.INSTANCE;
        boolean $i$f$getSPACE_OAUTH_CLIENT_ID = false;
        this_$iv = SpaceAccountConstants.INSTANCE;
        boolean $i$f$getSPACE_OAUTH_SECRET = false;
        String string = "toolbox-space-app" + ":" + "toolbox-space-app-secret";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.appAuth = "Basic " + Base64.encode$default((Base64)base64, (byte[])byArray, (int)0, (int)0, (int)6, null);
    }

    @Override
    @NotNull
    protected RefreshConfiguration createRefreshConfiguration(@NotNull SpaceAccount account2) {
        Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"grant_type", (Object)"refresh_token");
        SpaceAccountConstants this_$iv = SpaceAccountConstants.INSTANCE;
        boolean $i$f$getSPACE_OAUTH_CLIENT_ID = false;
        pairArray[1] = TuplesKt.to((Object)"client_id", (Object)"toolbox-space-app");
        return new RefreshConfigurationImpl(account2.getInstanceUrl() + "/oauth/token", MapsKt.mapOf((Pair[])pairArray), this.appAuth, ContentType.FORM_URL_ENCODED, false, 16, null);
    }

    @Override
    @NotNull
    protected OAuthSecureToken updateToken(@NotNull OAuthSecureToken previousToken, @NotNull OAuth2Token newToken2, @Nullable String requestId) {
        Intrinsics.checkNotNullParameter((Object)previousToken, (String)"previousToken");
        Intrinsics.checkNotNullParameter((Object)newToken2, (String)"newToken");
        return previousToken.updateFrom(newToken2);
    }
}

