/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts.space;

import com.jetbrains.toolbox.accounts.space.SpaceServiceConfig;
import com.jetbrains.toolbox.common.extensions.URIExtensionsKt;
import com.jetbrains.toolbox.manager.ServiceManager;
import com.jetbrains.toolbox.protocolhandler.ProtocolHandler;
import java.net.URI;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class SpaceLoginProtocolHandler
implements ProtocolHandler {
    @NotNull
    private final ServiceManager serviceManager;

    public SpaceLoginProtocolHandler(@NotNull ServiceManager serviceManager) {
        Intrinsics.checkNotNullParameter((Object)serviceManager, (String)"serviceManager");
        this.serviceManager = serviceManager;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Object canHandle(@NotNull URI uri, @NotNull Continuation<? super Boolean> $completion) {
        boolean bl;
        if (Intrinsics.areEqual((Object)uri.getHost(), (Object)"toolbox")) {
            String string = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (StringsKt.startsWith$default((String)string, (String)"/space/connect", (boolean)false, (int)2, null)) {
                bl = true;
                return Boxing.boxBoolean((boolean)bl);
            }
        }
        bl = false;
        return Boxing.boxBoolean((boolean)bl);
    }

    @Override
    @Nullable
    public Object handle(@NotNull URI uri, @NotNull Continuation<? super Unit> $completion) {
        String url = URIExtensionsKt.parseQuery(uri).get("url");
        if (url == null) {
            Logger.INSTANCE.warn("No url param was provided: " + uri);
            return Unit.INSTANCE;
        }
        Object object = this.serviceManager.connect("space", new SpaceServiceConfig(url), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

