/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts.jba;

import com.jetbrains.toolbox.accounts.JetBrainsAccount;
import com.jetbrains.toolbox.accounts.JetBrainsAccountSecureToken;
import com.jetbrains.toolbox.accounts.RefreshConfigurationImpl;
import com.jetbrains.toolbox.accounts.jba.JBAAuthUrls;
import com.jetbrains.toolbox.accounts.jba.JBAConstants;
import com.jetbrains.toolbox.accounts.jba.JetBrainsAccountConfig;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Token;
import com.jetbrains.toolbox.accounts.oauth.OAuthTokenRefresherImpl;
import com.jetbrains.toolbox.api.core.auth.ContentType;
import com.jetbrains.toolbox.api.core.auth.RefreshConfiguration;
import com.jetbrains.toolbox.network.BasicDownloadManager;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nJetBrainsAccountTokenRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetBrainsAccountTokenRefresher.kt\ncom/jetbrains/toolbox/accounts/jba/JetBrainsAccountTokenRefresher\n+ 2 JBAConstants.kt\ncom/jetbrains/toolbox/accounts/jba/JBAConstants\n*L\n1#1,40:1\n8#2:41\n*S KotlinDebug\n*F\n+ 1 JetBrainsAccountTokenRefresher.kt\ncom/jetbrains/toolbox/accounts/jba/JetBrainsAccountTokenRefresher\n*L\n28#1:41\n*E\n"})
public final class JetBrainsAccountTokenRefresher
extends OAuthTokenRefresherImpl<JetBrainsAccount, JetBrainsAccountSecureToken> {
    @NotNull
    private final JetBrainsAccountConfig jbaConfig;

    public JetBrainsAccountTokenRefresher(@NotNull BasicDownloadManager downloadManager, @NotNull Clock clock, @NotNull JetBrainsAccountConfig jbaConfig) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)jbaConfig, (String)"jbaConfig");
        super("JetBrains Account", downloadManager, clock);
        this.jbaConfig = jbaConfig;
    }

    @Override
    @NotNull
    protected RefreshConfiguration createRefreshConfiguration(@NotNull JetBrainsAccount account2) {
        Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"grant_type", (Object)"refresh_token");
        JBAConstants this_$iv = JBAConstants.INSTANCE;
        boolean $i$f$getJBA_OAUTH_REDIRECT_URI = false;
        Object[] objectArray = new String[]{"jetbrains://", "toolbox", "/jba", "/auth"};
        pairArray[1] = TuplesKt.to((Object)"redirect_uri", (Object)SequencesKt.joinToString$default((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        pairArray[2] = TuplesKt.to((Object)"client_id", (Object)this.jbaConfig.getOAuthClientId());
        return new RefreshConfigurationImpl(((JBAAuthUrls)this.jbaConfig.getUrls().getValue()).getTokenUrl(), MapsKt.mapOf((Pair[])pairArray), null, ContentType.FORM_URL_ENCODED, true);
    }

    @Override
    @NotNull
    protected JetBrainsAccountSecureToken updateToken(@NotNull JetBrainsAccountSecureToken previousToken, @NotNull OAuth2Token newToken2, @Nullable String requestId) {
        Intrinsics.checkNotNullParameter((Object)previousToken, (String)"previousToken");
        Intrinsics.checkNotNullParameter((Object)newToken2, (String)"newToken");
        return previousToken.updateFrom(newToken2, requestId);
    }
}

