/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts;

import com.jetbrains.toolbox.accounts.GoogleAccountSecureToken$;
import com.jetbrains.toolbox.accounts.SecureAccountToken;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Token;
import com.jetbrains.toolbox.common.serialization.InstantAsEpochSecondsSerializer;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
public final class GoogleAccountSecureToken
extends SecureAccountToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String accessToken;
    @NotNull
    private final String idToken;
    @NotNull
    private final String refreshToken;
    @NotNull
    private final String scope;
    @NotNull
    private final String tokenType;
    @Nullable
    private final Instant expiresAt;
    @Nullable
    private final String requestId;

    public GoogleAccountSecureToken(@NotNull String accessToken2, @NotNull String idToken, @NotNull String refreshToken, @NotNull String scope2, @NotNull String tokenType, @Nullable Instant expiresAt, @Nullable String requestId) {
        Intrinsics.checkNotNullParameter((Object)accessToken2, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        super(null);
        this.accessToken = accessToken2;
        this.idToken = idToken;
        this.refreshToken = refreshToken;
        this.scope = scope2;
        this.tokenType = tokenType;
        this.expiresAt = expiresAt;
        this.requestId = requestId;
    }

    @Override
    @NotNull
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    @NotNull
    public String getIdToken() {
        return this.idToken;
    }

    @Override
    @NotNull
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @NotNull
    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    @Nullable
    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    @Override
    @Nullable
    public String getRequestId() {
        return this.requestId;
    }

    public GoogleAccountSecureToken(@NotNull OAuth2Token oAuth2Token, @Nullable String requestId) {
        Intrinsics.checkNotNullParameter((Object)oAuth2Token, (String)"oAuth2Token");
        String string = oAuth2Token.getAccessToken();
        Intrinsics.checkNotNull((Object)string);
        String string2 = oAuth2Token.getIdToken();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = oAuth2Token.getRefreshToken();
        Intrinsics.checkNotNull((Object)string3);
        String string4 = oAuth2Token.getScope();
        Intrinsics.checkNotNull((Object)string4);
        String string5 = oAuth2Token.getTokenType();
        Intrinsics.checkNotNull((Object)string5);
        this(string, string2, string3, string4, string5, oAuth2Token.getExpiresAt(), requestId);
    }

    public /* synthetic */ GoogleAccountSecureToken(OAuth2Token oAuth2Token, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(oAuth2Token, string);
    }

    @Override
    @NotNull
    public String getAuthorizationHeader() {
        return this.getTokenType() + " " + this.getIdToken();
    }

    @NotNull
    public final GoogleAccountSecureToken updateFrom(@NotNull OAuth2Token token2, @Nullable String requestId) {
        String string;
        String string2;
        String string3;
        String string4;
        Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
        String string5 = token2.getAccessToken();
        if (string5 == null) {
            string5 = this.getAccessToken();
        }
        if ((string4 = token2.getIdToken()) == null) {
            string4 = this.getIdToken();
        }
        if ((string3 = token2.getRefreshToken()) == null) {
            string3 = this.getRefreshToken();
        }
        if ((string2 = token2.getScope()) == null) {
            string2 = this.scope;
        }
        if ((string = token2.getTokenType()) == null) {
            string = this.getTokenType();
        }
        return this.copy(string5, string4, string3, string2, string, token2.getExpiresAt(), requestId);
    }

    @NotNull
    public final GoogleAccountSecureToken copy(@NotNull String accessToken2, @NotNull String idToken, @NotNull String refreshToken, @NotNull String scope2, @NotNull String tokenType, @Nullable Instant expiresAt, @Nullable String requestId) {
        Intrinsics.checkNotNullParameter((Object)accessToken2, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return new GoogleAccountSecureToken(accessToken2, idToken, refreshToken, scope2, tokenType, expiresAt, requestId);
    }

    @NotNull
    public String toString() {
        return "GoogleAccountSecureToken(accessToken=" + this.accessToken + ", idToken=" + this.idToken + ", refreshToken=" + this.refreshToken + ", scope=" + this.scope + ", tokenType=" + this.tokenType + ", expiresAt=" + this.expiresAt + ", requestId=" + this.requestId + ")";
    }

    public int hashCode() {
        int result2 = this.accessToken.hashCode();
        result2 = result2 * 31 + this.idToken.hashCode();
        result2 = result2 * 31 + this.refreshToken.hashCode();
        result2 = result2 * 31 + this.scope.hashCode();
        result2 = result2 * 31 + this.tokenType.hashCode();
        result2 = result2 * 31 + (this.expiresAt == null ? 0 : this.expiresAt.hashCode());
        result2 = result2 * 31 + (this.requestId == null ? 0 : this.requestId.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GoogleAccountSecureToken)) {
            return false;
        }
        GoogleAccountSecureToken googleAccountSecureToken = (GoogleAccountSecureToken)other;
        if (!Intrinsics.areEqual((Object)this.accessToken, (Object)googleAccountSecureToken.accessToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.idToken, (Object)googleAccountSecureToken.idToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.refreshToken, (Object)googleAccountSecureToken.refreshToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scope, (Object)googleAccountSecureToken.scope)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tokenType, (Object)googleAccountSecureToken.tokenType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.expiresAt, (Object)googleAccountSecureToken.expiresAt)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.requestId, (Object)googleAccountSecureToken.requestId);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$accounts_api(GoogleAccountSecureToken self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        SecureAccountToken.write$Self(self, output2, serialDesc);
        output2.encodeStringElement(serialDesc, 0, self.getAccessToken());
        output2.encodeStringElement(serialDesc, 1, self.getIdToken());
        output2.encodeStringElement(serialDesc, 2, self.getRefreshToken());
        output2.encodeStringElement(serialDesc, 3, self.scope);
        output2.encodeStringElement(serialDesc, 4, self.getTokenType());
        output2.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)InstantAsEpochSecondsSerializer.INSTANCE, (Object)self.getExpiresAt());
        if (output2.shouldEncodeElementDefault(serialDesc, 6) ? true : self.getRequestId() != null) {
            output2.encodeNullableSerializableElement(serialDesc, 6, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.getRequestId());
        }
    }

    public /* synthetic */ GoogleAccountSecureToken(int seen0, String accessToken2, String idToken, String refreshToken, String scope2, String tokenType, Instant expiresAt, String requestId, SerializationConstructorMarker serializationConstructorMarker) {
        if (63 != (0x3F & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)63, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        super(seen0, serializationConstructorMarker);
        this.accessToken = accessToken2;
        this.idToken = idToken;
        this.refreshToken = refreshToken;
        this.scope = scope2;
        this.tokenType = tokenType;
        this.expiresAt = expiresAt;
        this.requestId = (seen0 & 0x40) == 0 ? null : requestId;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<GoogleAccountSecureToken> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

