/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class TestUtil {
    @NotNull
    public static final TestUtil INSTANCE = new TestUtil();
    private static final boolean isLookupAllowed = Build.INSTANCE.isSNAPSHOT() || Intrinsics.areEqual((Object)System.getProperty("ALLOW_CHECKOUT_ROOT_LOOKUP"), (Object)"1") || Intrinsics.areEqual((Object)System.getenv("ALLOW_CHECKOUT_ROOT_LOOKUP"), (Object)"1");

    private TestUtil() {
    }

    public final boolean isLookupAllowed() {
        return isLookupAllowed;
    }

    @Nullable
    public final Path getLocalAgentPath() {
        Path path2;
        ThreadGuardKt.assertNotMainThread("java.nio.file.Files.exists()");
        String string = System.getProperty("toolbox.local.agent.path");
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)it)) {
                return null;
            }
            path2 = Path.of(it, new String[0]);
        } else {
            path2 = null;
        }
        return path2;
    }

    @Nullable
    public final Path resolveFromCheckoutRootOrNull(@NotNull String relativePathToCheck) {
        Intrinsics.checkNotNullParameter((Object)relativePathToCheck, (String)"relativePathToCheck");
        ThreadGuardKt.assertNotMainThread("java.nio.file.Files.exists()");
        if (!isLookupAllowed) {
            boolean $i$a$-require-TestUtil$resolveFromCheckoutRootOrNull$22 = false;
            String $i$a$-require-TestUtil$resolveFromCheckoutRootOrNull$22 = "Must operate on snapshot builds or have env var 'ALLOW_CHECKOUT_ROOT_LOOKUP' set to '1'";
            throw new IllegalArgumentException($i$a$-require-TestUtil$resolveFromCheckoutRootOrNull$22.toString());
        }
        Path startPoint = Path.of(System.getProperty("user.dir"), new String[0]);
        Logger.INSTANCE.debug("user.dir=" + startPoint);
        Path current = startPoint;
        while (true) {
            Path check2;
            if (Files.exists(check2 = current.resolve(relativePathToCheck), new LinkOption[0])) {
                Logger.INSTANCE.debug("found " + relativePathToCheck + " at " + check2);
                return check2;
            }
            if (current.getParent() == null) break;
        }
        Logger.INSTANCE.debug("Didn't find " + relativePathToCheck + " starting from " + startPoint);
        return null;
    }
}

