/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.platform.OS;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.Win32Exception;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StandardPathsKt {
    @NotNull
    public static final Path getLogsDirectory() {
        String string = System.getProperty("toolbox.log.path");
        if (string == null || (string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) == null) {
            string = OS.INSTANCE.isMac() ? StandardPaths.INSTANCE.getHome().resolve("Library").resolve("Logs").resolve("JetBrains").resolve(StandardPaths.INSTANCE.getToolboxDirName()) : StandardPaths.INSTANCE.getToolboxDataLocation().resolve("logs");
        }
        return string;
    }

    @Nullable
    public static final String getKnownFolderPathOrNull(@NotNull Guid.GUID knownFolderId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)knownFolderId, (String)"knownFolderId");
        try {
            string = Shell32Util.getKnownFolderPath((Guid.GUID)knownFolderId);
        }
        catch (Win32Exception e) {
            string = null;
        }
        return string;
    }
}

