/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.StandardPathsKt;
import com.jetbrains.toolbox.common.WellKnownPaths;
import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import com.jetbrains.toolbox.common.platform.OS;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nStandardPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardPaths.kt\ncom/jetbrains/toolbox/StandardPathsBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,216:1\n1563#2:217\n1634#2,3:218\n774#2:221\n865#2,2:222\n774#2:228\n865#2,2:229\n1563#2:231\n1634#2,3:232\n865#2,2:235\n1563#2:237\n1634#2,3:238\n11561#3:224\n11896#3,3:225\n*S KotlinDebug\n*F\n+ 1 StandardPaths.kt\ncom/jetbrains/toolbox/StandardPathsBase\n*L\n125#1:217\n125#1:218,3\n125#1:221\n125#1:222,2\n194#1:228\n194#1:229,2\n194#1:231\n194#1:232,3\n194#1:235,2\n79#1:237\n79#1:238,3\n192#1:224\n192#1:225,3\n*E\n"})
public class StandardPathsBase
implements WellKnownPaths {
    @NotNull
    private final String toolboxDirName;
    @NotNull
    private final Path Home;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final String separator;
    @NotNull
    private final String pathSeparator;
    @NotNull
    private final Path AppData;
    @NotNull
    private final Path ApplicationsLocationFile;
    @NotNull
    private final Lazy LocalAppData$delegate;
    @NotNull
    private final Lazy RoamingAppData$delegate;
    @NotNull
    private final Path ToolboxDataLocation;
    @NotNull
    private final Path UserInstallPath;
    @NotNull
    private final Path PluginDataPath;
    @NotNull
    private final Lazy SystemInstallPath$delegate;
    @NotNull
    private final Lazy AdditionalSystemInstallPaths$delegate;
    @NotNull
    private final Path ConfigLocationFile;
    @NotNull
    private final Path ToolboxCacheLocation;
    @NotNull
    private final Path toolboxBackupDir;
    @NotNull
    private final Path ApplicationDir;
    @NotNull
    private final Lazy ApplicationFile$delegate;
    @NotNull
    private final Path okioTempDir;
    @NotNull
    private final Path ConfigHome;
    @NotNull
    private final Path CacheHome;
    @NotNull
    private final Path DataHome;
    @NotNull
    private final Path LogsHome;
    @NotNull
    private final Path VSCodeConfigDir;

    public StandardPathsBase(@NotNull String toolboxDirName) {
        Object object;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)toolboxDirName, (String)"toolboxDirName");
        this.toolboxDirName = toolboxDirName;
        String string3 = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
        this.Home = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string3, (boolean)false, (int)1, null);
        this.fileSystem = FileSystem.SYSTEM;
        String string4 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"separator");
        this.separator = string4;
        String string5 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"pathSeparator");
        this.pathSeparator = string5;
        String string6 = System.getProperty("toolbox.appData.path");
        if (string6 == null || (string6 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string6, (boolean)false, (int)1, null)) == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
                case 1: {
                    string6 = System.getenv("APPDATA");
                    if (string6 != null && (string6 = StringExtensionsKt.getNullIfBlank(string6)) != null && (string6 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string6, (boolean)false, (int)1, null)) != null) break;
                    string6 = this.Home.resolve("AppData/Roaming");
                    break;
                }
                case 2: {
                    string6 = this.Home.resolve("Library/Application Support");
                    break;
                }
                case 3: {
                    string6 = System.getenv("XDG_DATA_HOME");
                    if (string6 != null && (string6 = StringExtensionsKt.getNullIfBlank(string6)) != null && (string6 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string6, (boolean)false, (int)1, null)) != null) break;
                    string6 = this.Home.resolve(".local/share");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        this.AppData = string6;
        String string7 = System.getProperty("toolbox.applicationsLocation.path");
        if (string7 == null || (string7 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string7, (boolean)false, (int)1, null)) == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
                case 3: {
                    string7 = this.Home.resolve(".local").resolve("share").resolve("applications");
                    break;
                }
                case 1: {
                    string7 = this.AppData.resolve("Microsoft").resolve("Windows").resolve("Start Menu").resolve("Programs");
                    break;
                }
                case 2: {
                    string7 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/Applications", (boolean)false, (int)1, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        this.ApplicationsLocationFile = string7;
        this.LocalAppData$delegate = LazyKt.lazy(() -> StandardPathsBase.LocalAppData_delegate$lambda$0(this));
        this.RoamingAppData$delegate = LazyKt.lazy(() -> StandardPathsBase.RoamingAppData_delegate$lambda$0(this));
        this.ToolboxDataLocation = this.getLocalAppData().resolve("JetBrains").resolve(this.toolboxDirName);
        String string8 = System.getProperty("toolbox.userInstall.path");
        if (string8 == null || (string8 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string8, (boolean)false, (int)1, null)) == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
                case 3: {
                    string8 = this.getLocalAppData().resolve("JetBrains").resolve("Toolbox").resolve("apps");
                    break;
                }
                case 1: {
                    Guid.GUID gUID = KnownFolders.FOLDERID_UserProgramFiles;
                    Intrinsics.checkNotNullExpressionValue((Object)gUID, (String)"FOLDERID_UserProgramFiles");
                    Object object2 = StandardPathsKt.getKnownFolderPathOrNull(gUID);
                    if (object2 == null) {
                        object2 = this.getLocalAppData() + "\\Programs";
                    }
                    string8 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)object2, (boolean)false, (int)1, null);
                    break;
                }
                case 2: {
                    String string9 = System.getProperty("user.home");
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getProperty(...)");
                    string8 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string9, (boolean)false, (int)1, null).resolve("Applications");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        this.UserInstallPath = string8;
        this.PluginDataPath = this.ToolboxDataLocation.resolve("plugins");
        this.SystemInstallPath$delegate = LazyKt.lazy(StandardPathsBase::SystemInstallPath_delegate$lambda$0);
        this.AdditionalSystemInstallPaths$delegate = LazyKt.lazy(StandardPathsBase::AdditionalSystemInstallPaths_delegate$lambda$0);
        String string10 = System.getProperty("toolbox.configLocation.path");
        if (string10 == null || (string10 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string10, (boolean)false, (int)1, null)) == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
                case 3: {
                    string10 = System.getenv("XDG_CONFIG_HOME");
                    if (string10 != null && (string10 = StringExtensionsKt.getNullIfBlank(string10)) != null && (string10 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string10, (boolean)false, (int)1, null)) != null) break;
                    string10 = this.Home.resolve(".config");
                    break;
                }
                case 2: {
                    string10 = this.Home.resolve("Library").resolve("Preferences");
                    break;
                }
                case 1: {
                    string10 = this.getLocalAppData();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        this.ConfigLocationFile = string10;
        String string11 = System.getProperty("toolbox.cacheLocation.path");
        if (string11 == null || (string11 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string11, (boolean)false, (int)1, null)) == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
                case 3: {
                    String string12 = System.getenv("XDG_CACHE_HOME");
                    if (string12 == null || (string12 = StringExtensionsKt.getNullIfBlank(string12)) == null || (string12 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string12, (boolean)false, (int)1, null)) == null) {
                        string12 = this.Home.resolve(".cache");
                    }
                    String cacheDirectory = string12;
                    string11 = cacheDirectory.resolve("JetBrains").resolve(this.toolboxDirName);
                    break;
                }
                case 1: {
                    string11 = this.ToolboxDataLocation.resolve("cache");
                    break;
                }
                case 2: {
                    string11 = this.Home.resolve("Library/Caches/JetBrains/" + this.toolboxDirName);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        this.ToolboxCacheLocation = string11;
        this.toolboxBackupDir = this.ToolboxCacheLocation.resolve("backup");
        String string13 = System.getProperty("toolbox.application.path");
        if (string13 == null || (string13 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string13, (boolean)false, (int)1, null)) == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
                case 1: {
                    Path path2 = OS.INSTANCE.getApplicationExecutable().parent();
                    string13 = path2;
                    Intrinsics.checkNotNull((Object)path2);
                    break;
                }
                case 2: {
                    String string14 = System.getProperty("user.dir");
                    Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"getProperty(...)");
                    Path path3 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string14, (boolean)false, (int)1, null).parent();
                    Intrinsics.checkNotNull((Object)path3);
                    Path path4 = path3.parent();
                    string13 = path4;
                    Intrinsics.checkNotNull((Object)path4);
                    break;
                }
                case 3: {
                    String string15 = System.getProperty("user.dir");
                    Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"getProperty(...)");
                    string13 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string15, (boolean)false, (int)1, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        this.ApplicationDir = string13;
        this.ApplicationFile$delegate = LazyKt.lazy(() -> StandardPathsBase.ApplicationFile_delegate$lambda$0(this));
        String string16 = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"getProperty(...)");
        this.okioTempDir = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string16, (boolean)false, (int)1, null);
        switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
            case 3: {
                string2 = System.getenv("XDG_CONFIG_HOME");
                if (string2 != null && (string2 = StringExtensionsKt.getNullIfBlank(string2)) != null && (string2 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string2, (boolean)false, (int)1, null)) != null) break;
                string2 = this.Home.resolve(".config");
                break;
            }
            case 1: {
                Guid.GUID gUID = KnownFolders.FOLDERID_RoamingAppData;
                Intrinsics.checkNotNullExpressionValue((Object)gUID, (String)"FOLDERID_RoamingAppData");
                string2 = StandardPathsKt.getKnownFolderPathOrNull(gUID);
                if (string2 != null && (string2 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string2, (boolean)false, (int)1, null)) != null) break;
                string2 = this.Home.resolve("AppData/Roaming");
                break;
            }
            case 2: {
                string2 = this.Home.resolve("Library/Application Support");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.ConfigHome = string2;
        switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
            case 3: {
                string = System.getenv("XDG_CACHE_HOME");
                if (string != null && (string = StringExtensionsKt.getNullIfBlank(string)) != null && (string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) != null) break;
                string = this.Home.resolve(".cache");
                break;
            }
            case 1: {
                Guid.GUID gUID = KnownFolders.FOLDERID_LocalAppData;
                Intrinsics.checkNotNullExpressionValue((Object)gUID, (String)"FOLDERID_LocalAppData");
                string = StandardPathsKt.getKnownFolderPathOrNull(gUID);
                if (string != null && (string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) != null) break;
                string = this.Home.resolve("AppData/Local");
                break;
            }
            case 2: {
                string = this.Home.resolve("Library/Caches");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.CacheHome = string;
        switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
            case 3: {
                object = System.getenv("XDG_DATA_HOME");
                if (object != null && (object = StringExtensionsKt.getNullIfBlank((String)object)) != null && (object = Path.Companion.get$default((Path.Companion)Path.Companion, (String)object, (boolean)false, (int)1, null)) != null) break;
                object = this.Home.resolve(".local/share");
                break;
            }
            case 1: 
            case 2: {
                object = this.getConfigHome();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.DataHome = object;
        this.LogsHome = switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
            case 1, 3 -> this.getCacheHome();
            case 2 -> this.Home.resolve("Library/Logs");
            default -> throw new NoWhenBranchMatchedException();
        };
        this.VSCodeConfigDir = (switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
            case 1, 2 -> this.AppData;
            case 3 -> this.ConfigLocationFile;
            default -> throw new NoWhenBranchMatchedException();
        }).resolve("JetBrains").resolve("VSCode");
    }

    @NotNull
    public final String getToolboxDirName() {
        return this.toolboxDirName;
    }

    @Override
    @NotNull
    public final Path getHome() {
        return this.Home;
    }

    @NotNull
    public final String getPathSeparator() {
        return this.pathSeparator;
    }

    @NotNull
    public final Path getApplicationsLocationFile() {
        return this.ApplicationsLocationFile;
    }

    @Override
    @NotNull
    public final Path getLocalAppData() {
        Lazy lazy = this.LocalAppData$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    public Path getRoamingAppData() {
        Lazy lazy = this.RoamingAppData$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    public final Path getToolboxDataLocation() {
        return this.ToolboxDataLocation;
    }

    @Override
    @NotNull
    public Path getUserInstallPath() {
        return this.UserInstallPath;
    }

    @NotNull
    public final Path getPluginDataPath() {
        return this.PluginDataPath;
    }

    @Override
    @NotNull
    public Path getSystemInstallPath() {
        Lazy lazy = this.SystemInstallPath$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    public List<Path> getAdditionalSystemInstallPaths() {
        Lazy lazy = this.AdditionalSystemInstallPaths$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final Path getConfigLocationFile() {
        return this.ConfigLocationFile;
    }

    @Override
    @NotNull
    public final Path getToolboxCacheLocation() {
        return this.ToolboxCacheLocation;
    }

    @NotNull
    public final Path getToolboxBackupDir() {
        return this.toolboxBackupDir;
    }

    @NotNull
    public final Path getDesktopLocation() {
        String string = System.getProperty("toolbox.desktopLocation.path");
        if (string == null || (string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) == null) {
            string = this.Home.resolve("Desktop");
        }
        return string;
    }

    @Override
    @NotNull
    public final Path getApplicationDir() {
        return this.ApplicationDir;
    }

    @NotNull
    public final Path getApplicationFile() {
        Lazy lazy = this.ApplicationFile$delegate;
        return (Path)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> getApplicationDirs() {
        void $this$filterTo$iv$iv;
        Path it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getXdgDataDirs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.resolve("applications"));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Path)element$iv$iv;
            boolean bl = false;
            if (!this.fileSystem.exists(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)this.ApplicationsLocationFile);
    }

    @NotNull
    public final Path getOkioTempDir() {
        return this.okioTempDir;
    }

    @Override
    @NotNull
    public Path getToolboxSystemDataLocation() {
        String string = System.getProperty("toolbox.systemDataLocation.path");
        if (string == null || (string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
                case 3: {
                    String string2 = this.toolboxDirName.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)("/usr/share/jetbrains-" + string2), (boolean)false, (int)1, null);
                    break;
                }
                case 2: {
                    string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)("/Library/Application Support/JetBrains/" + this.toolboxDirName), (boolean)false, (int)1, null);
                    break;
                }
                case 1: {
                    Guid.GUID gUID = KnownFolders.FOLDERID_ProgramData;
                    Intrinsics.checkNotNullExpressionValue((Object)gUID, (String)"FOLDERID_ProgramData");
                    String string3 = StandardPathsKt.getKnownFolderPathOrNull(gUID);
                    if (string3 == null) {
                        string3 = "C:/ProgramData";
                    }
                    string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string3, (boolean)false, (int)1, null).resolve("JetBrains/" + this.toolboxDirName);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string;
    }

    @Override
    @NotNull
    public Path getConfigHome() {
        return this.ConfigHome;
    }

    @Override
    @NotNull
    public Path getCacheHome() {
        return this.CacheHome;
    }

    @Override
    @NotNull
    public Path getDataHome() {
        return this.DataHome;
    }

    @Override
    @NotNull
    public Path getLogsHome() {
        return this.LogsHome;
    }

    @Override
    @NotNull
    public Path getVSCodeConfigDir() {
        return this.VSCodeConfigDir;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> getXdgDataDirs() {
        String it;
        Object element$iv$iv;
        char[] $this$filterTo$iv$iv;
        Object $this$map$iv;
        String fromEnv = System.getenv("XDG_DATA_DIRS");
        String[] stringArray = (String[])fromEnv;
        if (stringArray == null || stringArray.length() == 0) {
            void $this$mapTo$iv$iv;
            stringArray = new String[]{"/usr/local/share", "/usr/share"};
            boolean $i$f$map = false;
            char[] cArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((char[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it2;
                void item$iv$iv;
                void var10_17 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Path.Companion.get$default((Path.Companion)Path.Companion, (String)it2, (boolean)false, (int)1, null));
            }
            return (List)destination$iv$iv;
        }
        $this$map$iv = new char[]{':'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)fromEnv, (char[])$this$map$iv, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable $this$mapTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)it).length() > 0 && StringsKt.startsWith$default((CharSequence)it, (char)'/', (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Path.Companion.get$default((Path.Companion)Path.Companion, (String)it, (boolean)false, (int)1, null));
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it = (Path)element$iv$iv;
            boolean bl = false;
            if (!this.fileSystem.exists((Path)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Path LocalAppData_delegate$lambda$0(StandardPathsBase this$0) {
        String string = System.getProperty("toolbox.localAppData.path");
        if (string == null || (string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
                case 1: {
                    Guid.GUID gUID = KnownFolders.FOLDERID_LocalAppData;
                    Intrinsics.checkNotNullExpressionValue((Object)gUID, (String)"FOLDERID_LocalAppData");
                    string = StandardPathsKt.getKnownFolderPathOrNull(gUID);
                    if (string != null && (string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) != null) break;
                    string = this$0.Home.resolve("AppData/Local");
                    break;
                }
                case 2: {
                    string = this$0.Home.resolve("Library/Application Support");
                    break;
                }
                case 3: {
                    string = System.getenv("XDG_DATA_HOME");
                    if (string != null && (string = StringExtensionsKt.getNullIfBlank(string)) != null && (string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) != null) break;
                    string = this$0.Home.resolve(".local/share");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string;
    }

    private static final Path RoamingAppData_delegate$lambda$0(StandardPathsBase this$0) {
        String string = System.getProperty("toolbox.roamingAppData.path");
        if (string == null || (string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
                case 1: {
                    Guid.GUID gUID = KnownFolders.FOLDERID_RoamingAppData;
                    Intrinsics.checkNotNullExpressionValue((Object)gUID, (String)"FOLDERID_RoamingAppData");
                    string = StandardPathsKt.getKnownFolderPathOrNull(gUID);
                    if (string != null && (string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) != null) break;
                    string = this$0.Home.resolve("AppData/Roaming");
                    break;
                }
                case 2: 
                case 3: {
                    string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"", (boolean)false, (int)1, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string;
    }

    private static final Path SystemInstallPath_delegate$lambda$0() {
        String string = System.getProperty("toolbox.systemInstall.path");
        if (string == null || (string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
                case 3: {
                    string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/usr/local/bin/", (boolean)false, (int)1, null);
                    break;
                }
                case 1: {
                    Guid.GUID gUID = KnownFolders.FOLDERID_ProgramFiles;
                    Intrinsics.checkNotNullExpressionValue((Object)gUID, (String)"FOLDERID_ProgramFiles");
                    String string2 = StandardPathsKt.getKnownFolderPathOrNull(gUID);
                    if (string2 == null) {
                        string2 = "C:\\Program Files\\";
                    }
                    string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string2, (boolean)false, (int)1, null);
                    break;
                }
                case 2: {
                    string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/Applications", (boolean)false, (int)1, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final List AdditionalSystemInstallPaths_delegate$lambda$0() {
        List paths;
        List list2;
        List list3;
        String[] stringArray;
        Object object = System.getProperty("toolbox.additionalSystemInstall.path");
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{";"}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Path.Companion.get$default((Path.Companion)Path.Companion, (String)it, (boolean)false, (int)1, null));
            }
            list3 = (List)destination$iv$iv;
        } else {
            list3 = null;
        }
        if ((list2 = (paths = list3)) == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
                case 3: {
                    list2 = CollectionsKt.emptyList();
                    break;
                }
                case 1: {
                    Guid.GUID gUID = KnownFolders.FOLDERID_ProgramFilesX86;
                    Intrinsics.checkNotNullExpressionValue((Object)gUID, (String)"FOLDERID_ProgramFilesX86");
                    String string = StandardPathsKt.getKnownFolderPathOrNull(gUID);
                    list2 = CollectionsKt.listOfNotNull(string != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null) : null);
                    break;
                }
                case 2: {
                    list2 = CollectionsKt.emptyList();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return list2;
    }

    private static final Path ApplicationFile_delegate$lambda$0(StandardPathsBase this$0) {
        String string = System.getProperty("toolbox.applicationFile.path");
        if (string == null || (string = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
                case 2: {
                    string = this$0.ApplicationDir.resolve("Contents").resolve("MacOS").resolve("jetbrains-toolbox");
                    break;
                }
                case 3: {
                    throw new IllegalStateException("ApplicationFile is not implemented on linux".toString());
                }
                case 1: {
                    string = this$0.ApplicationDir.resolve("jetbrains-toolbox");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

