/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandLineResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int result;
    @NotNull
    private final String output;
    @NotNull
    private final String error;

    public CommandLineResult(int result2, @NotNull String output2, @NotNull String error2) {
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        this.result = result2;
        this.output = output2;
        this.error = error2;
    }

    public final int getResult() {
        return this.result;
    }

    @NotNull
    public final String getOutput() {
        return this.output;
    }

    @NotNull
    public final String getError() {
        return this.error;
    }

    @NotNull
    public final String getMessage() {
        boolean bl;
        boolean bl2 = bl = !StringsKt.contains$default((CharSequence)this.output, (char)'\u0000', (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)this.error, (char)'\u0000', (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return this.result + "\u0000" + this.output + "\u0000" + this.error;
    }

    @NotNull
    public String toString() {
        return "CommandLineResult(result=" + this.result + ", output=" + this.output + ", error=" + this.error + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.result);
        result2 = result2 * 31 + this.output.hashCode();
        result2 = result2 * 31 + this.error.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommandLineResult)) {
            return false;
        }
        CommandLineResult commandLineResult = (CommandLineResult)other;
        if (this.result != commandLineResult.result) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.output, (Object)commandLineResult.output)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.error, (Object)commandLineResult.error);
    }

    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CommandLineResult parse(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            char[] cArray = new char[]{'\u0000'};
            List split = StringsKt.split$default((CharSequence)message2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            Object object = (String)CollectionsKt.getOrNull((List)split, (int)0);
            if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                return null;
            }
            int exitCode = (Integer)object;
            String string = (String)CollectionsKt.getOrNull((List)split, (int)1);
            if (string == null) {
                return null;
            }
            String stdout = string;
            String string2 = (String)CollectionsKt.getOrNull((List)split, (int)2);
            if (string2 == null) {
                return null;
            }
            String stderr = string2;
            return new CommandLineResult(exitCode, stdout, stderr);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

