/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.tools.model.ChannelId;
import java.util.Set;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AppRestartInhibitor {
    @NotNull
    public StateFlow<Boolean> getRestartRequested();

    public void preventRestart(@NotNull BlockOwner var1);

    public void enableRestart(@NotNull BlockOwner var1);

    @Nullable
    public Object requestRestart(@NotNull Function1<? super Continuation<?>, ? extends Object> var1, @NotNull Continuation<?> var2);

    @NotNull
    public StateFlow<Set<BlockOwner>> getRestartBlockedBy();

    public static sealed interface BlockOwner {

        public static final class ActiveConnection
        implements BlockOwner {
            @NotNull
            private final Object owner;

            public ActiveConnection(@NotNull Object owner2) {
                Intrinsics.checkNotNullParameter((Object)owner2, (String)"owner");
                this.owner = owner2;
            }

            @NotNull
            public String toString() {
                return "ActiveConnection(owner=" + this.owner + ")";
            }

            public int hashCode() {
                return this.owner.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ActiveConnection)) {
                    return false;
                }
                ActiveConnection activeConnection = (ActiveConnection)other;
                return Intrinsics.areEqual((Object)this.owner, (Object)activeConnection.owner);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public static final class UpdatingTool
        implements BlockOwner {
            @NotNull
            private final String owner;

            private UpdatingTool(String owner2) {
                Intrinsics.checkNotNullParameter((Object)owner2, (String)"owner");
                this.owner = owner2;
            }

            @NotNull
            public final String getOwner-5CZByfs() {
                return this.owner;
            }

            @NotNull
            public String toString() {
                return "UpdatingTool(owner=" + ChannelId.toString-impl(this.owner) + ")";
            }

            public int hashCode() {
                return ChannelId.hashCode-impl(this.owner);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UpdatingTool)) {
                    return false;
                }
                UpdatingTool updatingTool = (UpdatingTool)other;
                return ChannelId.equals-impl0(this.owner, updatingTool.owner);
            }

            public /* synthetic */ UpdatingTool(String owner2, DefaultConstructorMarker $constructor_marker) {
                this(owner2);
            }
        }
    }
}

