/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.tbe.config.machine;

import java.io.Closeable;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nTbeMachineConfigCertificates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TbeMachineConfigCertificates.kt\ncom/jetbrains/tbe/config/machine/TbeMachineConfigCertificates\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class TbeMachineConfigCertificates {
    @NotNull
    public static final TbeMachineConfigCertificates INSTANCE = new TbeMachineConfigCertificates();

    private TbeMachineConfigCertificates() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String saveCertificatePem(@NotNull X509Certificate certificate2) {
        Intrinsics.checkNotNullParameter((Object)certificate2, (String)"certificate");
        Closeable closeable = new StringWriter();
        Throwable throwable = null;
        try {
            StringWriter sw = (StringWriter)closeable;
            boolean bl = false;
            Closeable closeable2 = new JcaPEMWriter(sw);
            Throwable throwable2 = null;
            try {
                JcaPEMWriter it = (JcaPEMWriter)closeable2;
                boolean bl2 = false;
                it.writeObject(certificate2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public final X509Certificate loadCertificate(int index, @NotNull String pem) {
        X509Certificate t22;
        X509CertificateHolder x509CertificateHolder;
        Intrinsics.checkNotNullParameter((Object)pem, (String)"pem");
        try {
            Object object = new PEMParser(new StringReader(pem)).readObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bouncycastle.cert.X509CertificateHolder");
            x509CertificateHolder = (X509CertificateHolder)object;
        }
        catch (Exception t22) {
            throw new IllegalArgumentException("Failed to parse certificate block at index " + index + ". " + t22.getMessage() + ". PEM encoded certificate is expected, but was: " + StringsKt.take((String)pem, (int)40), t22);
        }
        X509CertificateHolder holder = x509CertificateHolder;
        try {
            X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(holder);
            Intrinsics.checkNotNull((Object)x509Certificate);
            t22 = x509Certificate;
        }
        catch (Exception t3) {
            throw new IllegalArgumentException("Failed to load certificate at index " + index + ". " + t3.getMessage(), t3);
        }
        X509Certificate cert = t22;
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            return null;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            return null;
        }
        catch (Exception t23) {
            throw new IllegalArgumentException("Certificate is no longer valid at index " + index + ". " + t23.getMessage(), t23);
        }
        return cert;
    }
}

