/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb;

import com.jetbrains.rhizomedb.Attribute;
import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.DBUtilKt;
import com.jetbrains.rhizomedb.Datom;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.IndexQuery;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.Schema;
import com.jetbrains.rhizomedb.Versioned;
import com.jetbrains.rhizomedb.VersionedEID;
import com.jetbrains.rhizomedb.impl.EntitiesImplKt;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nEntityAttribute.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityAttribute.kt\ncom/jetbrains/rhizomedb/EntityAttributeKt\n+ 2 CollectionsUtil.kt\nfleet/util/CollectionsUtilKt\n+ 3 CollectionsUtil.kt\nfleet/util/CollectionsUtilKt$singleOrNullOrThrow$1\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,365:1\n7#2,5:366\n12#2,8:372\n7#2,5:380\n12#2,8:386\n7#2,5:405\n12#2,8:411\n7#3:371\n7#3:385\n7#3:410\n808#4,11:394\n808#4,11:419\n1634#4,3:430\n1625#4:433\n1869#4:434\n1870#4:436\n1626#4:437\n1625#4:438\n1869#4:439\n1870#4:442\n1626#4:443\n1634#4,3:444\n1#5:435\n1#5:440\n1#5:441\n1#5:447\n*S KotlinDebug\n*F\n+ 1 EntityAttribute.kt\ncom/jetbrains/rhizomedb/EntityAttributeKt\n*L\n84#1:366,5\n84#1:372,8\n113#1:380,5\n113#1:386,8\n137#1:405,5\n137#1:411,8\n84#1:371\n113#1:385\n137#1:410\n137#1:394,11\n144#1:419,11\n256#1:430,3\n277#1:433\n277#1:434\n277#1:436\n277#1:437\n301#1:438\n301#1:439\n301#1:442\n301#1:443\n313#1:444,3\n277#1:435\n301#1:441\n*E\n"})
public final class EntityAttributeKt {
    @NotNull
    public static final <E extends Entity, T> Set<E> entities(@NotNull EntityAttribute<E, T> entityAttribute, @NotNull T value2) {
        Intrinsics.checkNotNullParameter(entityAttribute, (String)"entityAttribute");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        EntityAttribute<E, T> attribute = entityAttribute;
        boolean bl = false;
        return EntityAttributeKt.lookup(DbContext.Companion.getThreadBound(), attribute, value2);
    }

    @Nullable
    public static final <E extends Entity, T> E entity(@NotNull EntityAttribute<E, T> entityAttribute, @NotNull T value2) {
        Intrinsics.checkNotNullParameter(entityAttribute, (String)"entityAttribute");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return EntityAttributeKt.entity(DbContext.Companion.getThreadBound(), entityAttribute, value2);
    }

    @Nullable
    public static final <E extends Entity, T> E entity(@NotNull DbContext<? extends Q> $this$entity, @NotNull EntityAttribute<E, T> entityAttribute, @NotNull T value2) {
        Intrinsics.checkNotNullParameter($this$entity, (String)"<this>");
        Intrinsics.checkNotNullParameter(entityAttribute, (String)"entityAttribute");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return EntityAttributeKt.entity($this$entity.getImpl(), entityAttribute, value2);
    }

    @Nullable
    public static final <E extends Entity, T> E entity(@NotNull Q $this$entity, @NotNull EntityAttribute<E, T> entityAttribute, @NotNull T value2) {
        Entity entity;
        Intrinsics.checkNotNullParameter((Object)$this$entity, (String)"<this>");
        Intrinsics.checkNotNullParameter(entityAttribute, (String)"entityAttribute");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        EntityAttribute<E, T> attribute = entityAttribute;
        boolean bl = false;
        if (!Schema.getUnique-impl(Attribute.getSchema-HLBllEs(attribute.getAttr-dkwPBow()))) {
            boolean bl2 = false;
            String string = "attribute " + attribute + " is not unique";
            throw new IllegalArgumentException(string.toString());
        }
        VersionedEID versionedEID = (VersionedEID)$this$entity.queryIndex(new IndexQuery.LookupUnique(attribute.getAttr-dkwPBow(), EntityAttributeKt.toIndexValue(attribute, value2), null, 4, null));
        if (versionedEID != null) {
            VersionedEID v = versionedEID;
            boolean bl3 = false;
            entity = EntitiesImplKt.entity($this$entity, v.getEid());
        } else {
            entity = null;
        }
        return (E)entity;
    }

    @JvmName(name="getRequired")
    @NotNull
    public static final <E extends Entity, V> V getRequired(@NotNull E $this$get, @NotNull Attributes.Required<V> attribute) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        E entity = $this$get;
        boolean bl = false;
        return EntityAttributeKt.get(DbContext.Companion.getThreadBound(), entity, attribute);
    }

    @NotNull
    public static final <E extends Entity, V> V get(@NotNull DbContext<? extends Q> $this$get, @NotNull E entity, @NotNull Attributes.Required<V> attribute) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        return EntityAttributeKt.get($this$get.getImpl(), entity, attribute);
    }

    @NotNull
    public static final <E extends Entity, V> V get(@NotNull Q $this$get, @NotNull E entity, @NotNull Attributes.Required<V> attribute) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        Q $this$get_u24lambda_u241 = $this$get;
        boolean bl = false;
        Object t2 = $this$get_u24lambda_u241.queryIndex(new IndexQuery.GetOne(entity.getEid(), attribute.getAttr-dkwPBow(), true, null));
        if (t2 == null) {
            boolean bl2 = false;
            String string = "required attribute " + DBUtilKt.displayAttribute-4iVtCWM($this$get_u24lambda_u241, attribute.getAttr-dkwPBow()) + " is absent in entity " + DBUtilKt.displayEntity($this$get_u24lambda_u241, entity.getEid());
            throw new IllegalArgumentException(string.toString());
        }
        Versioned value2 = (Versioned)t2;
        return EntityAttributeKt.fromIndexValue($this$get_u24lambda_u241, (EntityAttribute)attribute, value2.getX());
    }

    @JvmName(name="getOptional")
    @Nullable
    public static final <E extends Entity, V> V getOptional(@NotNull E $this$get, @NotNull Attributes.Optional<V> attribute) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        E entity = $this$get;
        boolean bl = false;
        return EntityAttributeKt.get(DbContext.Companion.getThreadBound(), entity, attribute);
    }

    @Nullable
    public static final <E extends Entity, V> V get(@NotNull DbContext<? extends Q> $this$get, @NotNull E entity, @NotNull Attributes.Optional<V> attribute) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        return EntityAttributeKt.get($this$get.getImpl(), entity, attribute);
    }

    @Nullable
    public static final <E extends Entity, V> V get(@NotNull Q $this$get, @NotNull E entity, @NotNull Attributes.Optional<V> attribute) {
        V v;
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        Versioned versioned = (Versioned)$this$get.queryIndex(new IndexQuery.GetOne(entity.getEid(), attribute.getAttr-dkwPBow(), true, null));
        if (versioned != null) {
            Versioned value2 = versioned;
            boolean bl = false;
            v = EntityAttributeKt.fromIndexValue($this$get, (EntityAttribute)attribute, value2.getX());
        } else {
            v = null;
        }
        return v;
    }

    @JvmName(name="getMany")
    @NotNull
    public static final <E extends Entity, V> Set<V> getMany(@NotNull E $this$get, @NotNull Attributes.Many<V> attribute) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        E entity = $this$get;
        boolean bl = false;
        return EntityAttributeKt.get(DbContext.Companion.getThreadBound(), entity, attribute);
    }

    @NotNull
    public static final <E extends Entity, V> Set<V> get(@NotNull DbContext<? extends Q> $this$get, @NotNull E entity, @NotNull Attributes.Many<V> attribute) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        return EntityAttributeKt.get($this$get.getImpl(), entity, attribute);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <E extends Entity, V> Set<V> get(@NotNull Q $this$get, @NotNull E entity, @NotNull Attributes.Many<V> attribute) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        Iterable iterable = (Iterable)$this$get.queryIndex(new IndexQuery.GetMany(entity.getEid(), attribute.getAttr-dkwPBow(), null));
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Datom datom = (Datom)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Object v = datom.component3();
            collection.add(EntityAttributeKt.fromIndexValue($this$get, (EntityAttribute)attribute, v));
        }
        return (Set)destination$iv;
    }

    @NotNull
    public static final <E extends Entity, V> Set<E> lookup(@NotNull DbContext<? extends Q> $this$lookup, @NotNull EntityAttribute<E, V> attribute, @NotNull V value2) {
        Intrinsics.checkNotNullParameter($this$lookup, (String)"<this>");
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return EntityAttributeKt.lookup($this$lookup.getImpl(), attribute, value2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <E extends Entity, V> Set<E> lookup(@NotNull Q $this$lookup, @NotNull EntityAttribute<E, V> attribute, @NotNull V value2) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$lookup, (String)"<this>");
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Iterable iterable = (Iterable)$this$lookup.queryIndex(new IndexQuery.LookupMany(attribute.getAttr-dkwPBow(), EntityAttributeKt.toIndexValue(attribute, value2), null, 4, null));
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Entity it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Datom datom = (Datom)element$iv;
            boolean bl2 = false;
            int eid2 = datom.component1();
            if (EntitiesImplKt.entity($this$lookup, eid2) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    @NotNull
    public static final <V> V fromIndexValue(@NotNull Q $this$fromIndexValue, @NotNull EntityAttribute<?, V> attribute, @NotNull Object value2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$fromIndexValue, (String)"<this>");
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        boolean bl = Schema.isRef-impl(Attribute.getSchema-HLBllEs(attribute.getAttr-dkwPBow()));
        if (bl) {
            object = EntitiesImplKt.entity($this$fromIndexValue, (int)((Integer)value2));
            if (object == null) {
                boolean bl2 = false;
                String string = "There is no entity object associated with eid " + value2;
                throw new IllegalStateException(string.toString());
            }
        } else if (!bl) {
            object = value2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type V of com.jetbrains.rhizomedb.EntityAttributeKt.fromIndexValue");
        return (V)object2;
    }

    @NotNull
    public static final <V> Object toIndexValue(@NotNull EntityAttribute<?, V> $this$toIndexValue, @NotNull V value2) {
        Object object;
        Intrinsics.checkNotNullParameter($this$toIndexValue, (String)"<this>");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        EntityAttribute<?, V> attribute = $this$toIndexValue;
        boolean bl = false;
        boolean bl2 = Schema.isRef-impl(Attribute.getSchema-HLBllEs(attribute.getAttr-dkwPBow()));
        if (bl2) {
            object = ((Entity)value2).getEid();
        } else if (!bl2) {
            object = value2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }
}

