/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb;

import com.jetbrains.rhizomedb.OutOfDbContext;
import com.jetbrains.rhizomedb.Q;
import fleet.multiplatform.shims.ThreadLocal;
import fleet.multiplatform.shims.ThreadLocalKt;
import java.util.concurrent.CancellationException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbContext<QQ extends Q> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Object privateValue;
    @Nullable
    private final Object dbSource;
    @NotNull
    private static final Object CloseMarker = new Object();
    @NotNull
    private static final ThreadLocal<DbContext<?>> threadLocal = ThreadLocalKt.ThreadLocal();

    public DbContext(@NotNull Object privateValue, @Nullable Object dbSource) {
        Intrinsics.checkNotNullParameter((Object)privateValue, (String)"privateValue");
        this.privateValue = privateValue;
        this.dbSource = dbSource;
    }

    @NotNull
    public final Object getPrivateValue() {
        return this.privateValue;
    }

    public final void setPrivateValue(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this.privateValue = object;
    }

    @Nullable
    public final Object getDbSource() {
        return this.dbSource;
    }

    @NotNull
    public final QQ getImpl() {
        Object q = this.privateValue;
        if (Intrinsics.areEqual((Object)q, (Object)CloseMarker)) {
            throw new Throwable("change closed");
        }
        if (q instanceof CancellationException) {
            CancellationException cancellationException;
            String string = "DBContext is poisoned";
            Throwable throwable = (Throwable)q;
            CancellationException cancellationException2 = cancellationException = new CancellationException(string);
            cancellationException2.initCause(throwable);
            throw cancellationException;
        }
        if (q instanceof Throwable) {
            throw new RuntimeException("DBContext is poisoned", (Throwable)q);
        }
        Intrinsics.checkNotNull((Object)q, (String)"null cannot be cast to non-null type QQ of com.jetbrains.rhizomedb.DbContext");
        return (QQ)((Q)q);
    }

    @Nullable
    public final Throwable getPoison() {
        Object object = this.privateValue;
        return object instanceof Throwable ? (Throwable)object : null;
    }

    public final void set(@NotNull Q q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        this.privateValue = q;
    }

    public final void setPoison(@NotNull Throwable x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        this.privateValue = x;
    }

    public final void markClosed() {
        this.privateValue = CloseMarker;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThreadLocal<DbContext<?>> getThreadLocal() {
            return threadLocal;
        }

        @NotNull
        public final DbContext<Q> getThreadBound() {
            DbContext<Q> dbContext = this.getThreadLocal().get();
            if (dbContext == null) {
                throw new OutOfDbContext();
            }
            return dbContext;
        }

        @Nullable
        public final DbContext<Q> getThreadBoundOrNull() {
            return this.getThreadLocal().get();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

