/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb;

import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.DB;
import com.jetbrains.rhizomedb.Novelty;
import fleet.util.openmap.BoundedOpenMap;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Change {
    @NotNull
    private final DB dbBefore;
    @NotNull
    private final DB dbAfter;
    @NotNull
    private final Novelty novelty;
    @NotNull
    private final BoundedOpenMap<ChangeScope, Object> meta;

    public Change(@NotNull DB dbBefore, @NotNull DB dbAfter, @NotNull Novelty novelty2, @NotNull BoundedOpenMap<ChangeScope, Object> meta) {
        Intrinsics.checkNotNullParameter((Object)dbBefore, (String)"dbBefore");
        Intrinsics.checkNotNullParameter((Object)dbAfter, (String)"dbAfter");
        Intrinsics.checkNotNullParameter((Object)novelty2, (String)"novelty");
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        this.dbBefore = dbBefore;
        this.dbAfter = dbAfter;
        this.novelty = novelty2;
        this.meta = meta;
    }

    @NotNull
    public final DB getDbBefore() {
        return this.dbBefore;
    }

    @NotNull
    public final DB getDbAfter() {
        return this.dbAfter;
    }

    @NotNull
    public final Novelty getNovelty() {
        return this.novelty;
    }

    @NotNull
    public final BoundedOpenMap<ChangeScope, Object> getMeta() {
        return this.meta;
    }

    @NotNull
    public String toString() {
        return "Change(dbBefore=" + this.dbBefore + ", dbAfter=" + this.dbAfter + ", novelty=" + this.novelty + ", meta=" + this.meta + ")";
    }

    public int hashCode() {
        int result2 = this.dbBefore.hashCode();
        result2 = result2 * 31 + this.dbAfter.hashCode();
        result2 = result2 * 31 + this.novelty.hashCode();
        result2 = result2 * 31 + this.meta.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Change)) {
            return false;
        }
        Change change2 = (Change)other;
        if (!Intrinsics.areEqual((Object)this.dbBefore, (Object)change2.dbBefore)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dbAfter, (Object)change2.dbAfter)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.novelty, (Object)change2.novelty)) {
            return false;
        }
        return Intrinsics.areEqual(this.meta, change2.meta);
    }
}

