/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.schema.generation;

import com.jetbrains.fus.reporting.schema.generation.EventDescriptor;
import com.jetbrains.fus.reporting.schema.generation.FieldDescriptor;
import com.jetbrains.fus.reporting.schema.generation.GroupDescriptor;
import com.jetbrains.fus.reporting.schema.generation.ValidationResult;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class SchemeValidator {
    @NotNull
    public static final SchemeValidator INSTANCE = new SchemeValidator();
    @NotNull
    private static final String SYMBOLS_TO_REPLACE_FIELD_NAME = ":;, ";

    private SchemeValidator() {
    }

    @NotNull
    public final ValidationResult validateEventScheme(@NotNull List<GroupDescriptor> eventSchemeGroups) {
        Intrinsics.checkNotNullParameter(eventSchemeGroups, (String)"eventSchemeGroups");
        HashSet groupNames = new HashSet();
        ValidationResult errors = new ValidationResult();
        for (GroupDescriptor group : eventSchemeGroups) {
            this.validateGroupScheme(group, groupNames, errors);
        }
        return errors;
    }

    private final void validateGroupScheme(GroupDescriptor group, Set<String> validatedGroupNames, ValidationResult errors) {
        String groupId = group.getId();
        if (StringsKt.isBlank((CharSequence)groupId)) {
            errors.addError(groupId, "Group id is empty");
        }
        if (!validatedGroupNames.add(groupId)) {
            errors.addError(groupId, "Duplicate group");
        }
        if (group.getVersion() <= 0) {
            errors.addError(groupId, "Group version should be not null and > 0");
        }
        this.validateEvents(group.getSchema(), groupId, errors);
    }

    private final void validateEvents(Set<EventDescriptor> schema, String groupId, ValidationResult errors) {
        if (schema.isEmpty()) {
            errors.addError(groupId, "Group should contains at least one event");
        }
        HashSet<String> eventsNames = new HashSet<String>();
        for (EventDescriptor event : schema) {
            String eventId = event.getEvent();
            if (StringsKt.isBlank((CharSequence)eventId)) {
                errors.addError(groupId, "Event id empty");
            } else if (!eventsNames.add(eventId)) {
                errors.addError(groupId, "Duplicate event (eventId=" + eventId + ')');
            }
            if (this.containsSystemSymbols(eventId, null)) {
                errors.addError(groupId, "Only printable ASCII symbols except '\" are allowed in event name (eventId=" + eventId + ')');
            }
            this.validateFields(event.getFields(), errors, groupId, eventId);
        }
    }

    private final void validateFields(Set<FieldDescriptor> fields2, ValidationResult errors, String groupId, String eventId) {
        for (FieldDescriptor field : fields2) {
            String fieldName = field.getPath();
            if (StringsKt.isBlank((CharSequence)fieldName)) {
                errors.addError(groupId, "Field path is empty (eventId=" + eventId + ')');
            }
            if (this.containsSystemSymbols(fieldName, SYMBOLS_TO_REPLACE_FIELD_NAME)) {
                errors.addError(groupId, "Only printable ASCII symbols except whitespaces and .:;,'\" are allowed in field name (eventId=" + eventId + ", field=" + fieldName + ')');
            }
            this.validateRules(errors, groupId, eventId, fieldName, field.getValue());
        }
    }

    private final void validateRules(ValidationResult errors, String groupId, String eventId, String fieldName, Set<String> rules) {
        if (rules.isEmpty()) {
            errors.addError(groupId, "Validation rules are not specified (eventId=" + eventId + ", field=" + fieldName + ')');
        }
        for (String validationRule : rules) {
            String rule;
            if (StringsKt.isBlank((CharSequence)validationRule)) {
                errors.addError(groupId, "Validation rule is empty (eventId=" + eventId + ", field=" + fieldName + ')');
            }
            if (Intrinsics.areEqual((Object)validationRule, (Object)"{regexp:.*}") || Intrinsics.areEqual((Object)validationRule, (Object)"{regexp:.+}")) {
                errors.addError(groupId, "Regexp should be more strict to prevent accidentally reporting sensitive data (eventId=" + eventId + ", field=" + fieldName + ')');
            }
            if (!StringsKt.startsWith$default((String)(rule = this.unwrapRule(validationRule)), (String)"enum:", (boolean)false, (int)2, null) || !this.containsSystemSymbols(validationRule, null)) continue;
            errors.addError(groupId, "Only printable ASCII symbols except '\" are allowed in validation rule (eventId=" + eventId + ", field=" + fieldName + ')');
        }
    }

    private final String unwrapRule(String rule) {
        String string;
        String trimmedRule = ((Object)StringsKt.trim((CharSequence)rule)).toString();
        if (StringsKt.startsWith$default((String)trimmedRule, (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)trimmedRule, (String)"}", (boolean)false, (int)2, null)) {
            String string2 = trimmedRule.substring(1, trimmedRule.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = rule;
        }
        return string;
    }

    private final boolean containsSystemSymbols(String value2, String toReplace) {
        if (value2 == null) {
            return false;
        }
        for (int j = 0; j < value2.length(); ++j) {
            char element = value2.charAt(j);
            if (!this.isAscii(element)) {
                return true;
            }
            if (this.isWhiteSpaceToReplace(element)) {
                return true;
            }
            if (this.isSymbolToReplace(element, toReplace)) {
                return true;
            }
            if (!this.isProhibitedSymbol(element)) continue;
            return true;
        }
        return false;
    }

    private final boolean isAscii(char c) {
        return c <= '\u007f';
    }

    private final boolean isSymbolToReplace(char c, String toReplace) {
        return toReplace != null && this.containsChar(toReplace, c) ? true : this.isAsciiControl(c);
    }

    private final boolean isWhiteSpaceToReplace(char c) {
        return c == '\n' || c == '\r' || c == '\t';
    }

    private final boolean isAsciiControl(char c) {
        return c < ' ' || c == '\u007f';
    }

    private final boolean isProhibitedSymbol(char c) {
        return c == '\'' || c == '\"';
    }

    private final boolean containsChar(String str, char c) {
        int n = str.length();
        for (int j = 0; j < n; ++j) {
            char element = str.charAt(j);
            if (element != c) continue;
            return true;
        }
        return false;
    }
}

