/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.system;

import com.intellij.openapi.util.Version;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OS
extends Enum<OS> {
    public static final /* enum */ OS Windows = new OS();
    public static final /* enum */ OS macOS = new OS();
    public static final /* enum */ OS Linux = new OS();
    public static final /* enum */ OS FreeBSD = new OS();
    public static final /* enum */ OS Other = new OS();
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public final String version = VersionHolder.access$000();
    public static final OS CURRENT;
    private static final /* synthetic */ OS[] $VALUES;

    @NotNull
    public static OS fromString(@Nullable String os) {
        if (os != null) {
            if ((os = os.toLowerCase(Locale.ENGLISH)).startsWith("windows")) {
                OS oS = Windows;
                if (oS == null) {
                    OS.$$$reportNull$$$0(3);
                }
                return oS;
            }
            if (os.startsWith("mac")) {
                OS oS = macOS;
                if (oS == null) {
                    OS.$$$reportNull$$$0(4);
                }
                return oS;
            }
            if (os.startsWith("linux")) {
                OS oS = Linux;
                if (oS == null) {
                    OS.$$$reportNull$$$0(5);
                }
                return oS;
            }
            if (os.startsWith("freebsd")) {
                OS oS = FreeBSD;
                if (oS == null) {
                    OS.$$$reportNull$$$0(6);
                }
                return oS;
            }
        }
        OS oS = Other;
        if (oS == null) {
            OS.$$$reportNull$$$0(7);
        }
        return oS;
    }

    private static /* synthetic */ OS[] $values() {
        return new OS[]{Windows, macOS, Linux, FreeBSD, Other};
    }

    static {
        $VALUES = OS.$values();
        CURRENT = OS.fromString(System.getProperty("os.name"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/system/OS";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "version";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parsedVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOsInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatform";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class VersionHolder {
        private static final String STR;
        private static final Version VAL;

        static /* synthetic */ String access$000() {
            return STR;
        }

        static {
            String name2 = System.getProperty("os.name");
            String version = System.getProperty("os.version", "unknown").toLowerCase(Locale.ENGLISH);
            if (name2.startsWith("Windows") && name2.matches("Windows \\d+")) {
                try {
                    String version2 = name2.substring("Windows".length() + 1) + ".0";
                    if (Float.parseFloat(version2) > Float.parseFloat(version)) {
                        version = version2;
                    }
                }
                catch (NumberFormatException version2) {
                    // empty catch block
                }
            }
            STR = version;
            Version parsed = Version.parseVersion(version);
            VAL = parsed != null ? parsed : new Version(0, 0, 0);
        }
    }
}

