/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.lang.reflect.Array;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ArrayUtil {
    public static final char[] EMPTY_CHAR_ARRAY = ArrayUtilRt.EMPTY_CHAR_ARRAY;
    public static final byte[] EMPTY_BYTE_ARRAY = ArrayUtilRt.EMPTY_BYTE_ARRAY;
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final int[] EMPTY_INT_ARRAY = ArrayUtilRt.EMPTY_INT_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY = ArrayUtilRt.EMPTY_STRING_ARRAY;
    public static final Class[] EMPTY_CLASS_ARRAY = ArrayUtilRt.EMPTY_CLASS_ARRAY;
    public static final long[] EMPTY_LONG_ARRAY = ArrayUtilRt.EMPTY_LONG_ARRAY;
    public static final File[] EMPTY_FILE_ARRAY = ArrayUtilRt.EMPTY_FILE_ARRAY;
    public static final Runnable[] EMPTY_RUNNABLE_ARRAY = new Runnable[0];
    @Deprecated
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new String();
    public static final ArrayFactory<String> STRING_ARRAY_FACTORY = ArrayUtil::newStringArray;
    public static final ArrayFactory<Object> OBJECT_ARRAY_FACTORY = ArrayUtil::newObjectArray;

    private ArrayUtil() {
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] realloc(T @NotNull [] array, int newSize, @NotNull ArrayFactory<? extends T> factory2) {
        int oldSize;
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(18);
        }
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(19);
        }
        if ((oldSize = array.length) == newSize) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(20);
            }
            return array;
        }
        T[] result2 = factory2.create(newSize);
        if (newSize == 0) {
            if (result2 == null) {
                ArrayUtil.$$$reportNull$$$0(21);
            }
            return result2;
        }
        System.arraycopy(array, 0, result2, 0, Math.min(oldSize, newSize));
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(22);
        }
        return result2;
    }

    @Contract(pure=true)
    public static char @NotNull [] insert(char @NotNull [] array, int index, char value2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(33);
        }
        char[] result2 = new char[array.length + 1];
        System.arraycopy(array, 0, result2, 0, index);
        result2[index] = value2;
        System.arraycopy(array, index, result2, index + 1, array.length - index);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(34);
        }
        return result2;
    }

    public static <T> T @NotNull [] newArray(@NotNull Class<T> type2, int length) {
        if (type2 == null) {
            ArrayUtil.$$$reportNull$$$0(105);
        }
        Object[] objectArray = (Object[])Array.newInstance(type2, length);
        if (objectArray == null) {
            ArrayUtil.$$$reportNull$$$0(106);
        }
        return objectArray;
    }

    @Contract(pure=true)
    public static String @NotNull [] newStringArray(int count) {
        return count == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : new String[count];
    }

    @Contract(pure=true)
    public static Object @NotNull [] newObjectArray(int count) {
        return count == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[count];
    }

    @NotNull
    public static <T> Class<T> getComponentType(T @NotNull [] collection) {
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(171);
        }
        Class<?> clazz = collection.getClass().getComponentType();
        if (clazz == null) {
            ArrayUtil.$$$reportNull$$$0(172);
        }
        return clazz;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 86: 
            case 91: 
            case 94: 
            case 96: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 113: 
            case 115: 
            case 117: 
            case 127: 
            case 129: 
            case 157: 
            case 158: 
            case 162: 
            case 172: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 86: 
            case 91: 
            case 94: 
            case 96: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 113: 
            case 115: 
            case 117: 
            case 127: 
            case 129: 
            case 157: 
            case 158: 
            case 162: 
            case 172: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 86: 
            case 91: 
            case 94: 
            case 96: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 113: 
            case 115: 
            case 117: 
            case 127: 
            case 129: 
            case 157: 
            case 158: 
            case 162: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ArrayUtil";
                break;
            }
            case 18: 
            case 59: 
            case 61: 
            case 82: 
            case 92: 
            case 97: 
            case 107: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 42: 
            case 48: 
            case 81: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 52: 
            case 62: 
            case 67: 
            case 69: 
            case 74: 
            case 79: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 53: 
            case 63: 
            case 68: 
            case 70: 
            case 75: 
            case 80: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 87: 
            case 93: 
            case 98: 
            case 101: 
            case 103: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 116: 
            case 118: 
            case 119: 
            case 151: 
            case 152: 
            case 153: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 89: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 123: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subArray";
                break;
            }
            case 130: 
            case 132: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj1";
                break;
            }
            case 131: 
            case 133: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj2";
                break;
            }
            case 142: 
            case 143: 
            case 146: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 147: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ints";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 164: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
            case 166: 
            case 167: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalityCondition";
                break;
            }
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr1";
                break;
            }
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ArrayUtil";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "realloc";
                break;
            }
            case 24: 
            case 26: 
            case 36: 
            case 38: 
            case 99: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 28: 
            case 30: 
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "insert";
                break;
            }
            case 44: 
            case 47: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "toObjectArray";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "toIntArray";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeArrays";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollections";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeArrayAndCollection";
                break;
            }
            case 91: 
            case 94: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "prepend";
                break;
            }
            case 104: 
            case 109: 
            case 113: 
            case 115: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "newArray";
                break;
            }
            case 127: 
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseArray";
                break;
            }
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureExactSize";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringArray";
                break;
            }
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "stripTrailingNulls";
                break;
            }
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "realloc";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 86: 
            case 91: 
            case 94: 
            case 96: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 113: 
            case 115: 
            case 117: 
            case 127: 
            case 129: 
            case 157: 
            case 158: 
            case 162: 
            case 172: {
                break;
            }
            case 23: 
            case 25: 
            case 35: 
            case 37: 
            case 87: 
            case 97: 
            case 98: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "toObjectArray";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "toIntArray";
                break;
            }
            case 52: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "mergeArrays";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollections";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "mergeArrayAndCollection";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 103: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "newArray";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 126: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "reverseArray";
                break;
            }
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "lexicographicCompare";
                break;
            }
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "swap";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "rotateLeft";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "rotateRight";
                break;
            }
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfNot";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "ensureExactSize";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "stripTrailingNulls";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "trailingNullsIndex";
                break;
            }
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "averageAmongMedians";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "min";
                break;
            }
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "max";
                break;
            }
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "mergeSortedArrays";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "getComponentType";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIdentity";
                break;
            }
            case 174: 
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "areEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 86: 
            case 91: 
            case 94: 
            case 96: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 113: 
            case 115: 
            case 117: 
            case 127: 
            case 129: 
            case 157: 
            case 158: 
            case 162: 
            case 172: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

