/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.util.text.CharArrayCharSequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LineTokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence myText;
    private int offset;
    private int length;
    private int lineSeparatorLength;
    private boolean atEnd;
    @NotNull
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public LineTokenizer(@NotNull CharSequence myText) {
        Intrinsics.checkNotNullParameter((Object)myText, (String)"myText");
        this.myText = myText;
        this.advance();
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getLineSeparatorLength() {
        return this.lineSeparatorLength;
    }

    public LineTokenizer(@NotNull char[] text2, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this(new CharArrayCharSequence(text2, startOffset, endOffset));
    }

    public final boolean atEnd() {
        return this.atEnd;
    }

    public final void advance() {
        int i2 = this.offset + this.length + this.lineSeparatorLength;
        int textLength = this.myText.length();
        if (i2 >= textLength) {
            this.atEnd = true;
            return;
        }
        block6: while (i2 < textLength) {
            char c = this.myText.charAt(i2);
            switch (c) {
                case '\n': 
                case '\r': {
                    break block6;
                }
                default: {
                    ++i2;
                    continue block6;
                }
            }
        }
        this.offset += this.length + this.lineSeparatorLength;
        this.length = i2 - this.offset;
        this.lineSeparatorLength = 0;
        if (i2 == textLength) {
            return;
        }
        char first = this.myText.charAt(i2);
        switch (first) {
            case '\n': 
            case '\r': {
                this.lineSeparatorLength = 1;
            }
        }
        if (++i2 == textLength) {
            return;
        }
        char second = this.myText.charAt(i2);
        if (first == '\r' && second == '\n') {
            this.lineSeparatorLength = 2;
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] tokenize(@Nullable CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        return Companion.tokenize(chars, includeSeparators, skipLastEmptyLine);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<String> tokenizeIntoList(@Nullable CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        return Companion.tokenizeIntoList(chars, includeSeparators, skipLastEmptyLine);
    }

    @JvmStatic
    public static final int calcLineCount(@NotNull CharSequence chars, boolean skipLastEmptyLine) {
        return Companion.calcLineCount(chars, skipLastEmptyLine);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] tokenize(@NotNull char[] chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        return Companion.tokenize(chars, includeSeparators, skipLastEmptyLine);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] tokenize(@Nullable CharSequence chars, boolean includeSeparators) {
        return Companion.tokenize(chars, includeSeparators);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<String> tokenizeIntoList(@Nullable CharSequence chars, boolean includeSeparators) {
        return Companion.tokenizeIntoList(chars, includeSeparators);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String[] tokenize(@NotNull char[] chars, boolean includeSeparators) {
        return Companion.tokenize(chars, includeSeparators);
    }

    @SourceDebugExtension(value={"SMAP\nLineTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineTokenizer.kt\ncom/intellij/openapi/util/text/LineTokenizer$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,134:1\n37#2,2:135\n*S KotlinDebug\n*F\n+ 1 LineTokenizer.kt\ncom/intellij/openapi/util/text/LineTokenizer$Companion\n*L\n65#1:135,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String[] tokenize(@Nullable CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
            String[] stringArray;
            List<String> strings = this.tokenizeIntoList(chars, includeSeparators, skipLastEmptyLine);
            if (strings.isEmpty()) {
                stringArray = EMPTY_STRING_ARRAY;
            } else {
                Collection $this$toTypedArray$iv = strings;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                stringArray = thisCollection$iv.toArray(new String[0]);
            }
            return stringArray;
        }

        public static /* synthetic */ String[] tokenize$default(Companion companion, CharSequence charSequence, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return companion.tokenize(charSequence, bl, bl2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final List<String> tokenizeIntoList(@Nullable CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
            if (chars == null || chars.length() == 0) {
                return new ArrayList();
            }
            LineTokenizer tokenizer = new LineTokenizer(chars);
            List lines = new ArrayList();
            while (!tokenizer.atEnd()) {
                int offset = tokenizer.getOffset();
                String line = includeSeparators ? ((Object)chars.subSequence(offset, offset + tokenizer.getLength() + tokenizer.getLineSeparatorLength())).toString() : ((Object)chars.subSequence(offset, offset + tokenizer.getLength())).toString();
                lines.add(line);
                tokenizer.advance();
            }
            if (!skipLastEmptyLine && this.stringEndsWithSeparator(tokenizer)) {
                lines.add("");
            }
            return lines;
        }

        public static /* synthetic */ List tokenizeIntoList$default(Companion companion, CharSequence charSequence, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return companion.tokenizeIntoList(charSequence, bl, bl2);
        }

        @JvmStatic
        public final int calcLineCount(@NotNull CharSequence chars, boolean skipLastEmptyLine) {
            Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
            int lineCount = 0;
            if (chars.length() > 0) {
                LineTokenizer tokenizer = new LineTokenizer(chars);
                while (!tokenizer.atEnd()) {
                    ++lineCount;
                    tokenizer.advance();
                }
                if (!skipLastEmptyLine && this.stringEndsWithSeparator(tokenizer)) {
                    ++lineCount;
                }
            }
            return lineCount;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String[] tokenize(@NotNull char[] chars, boolean includeSeparators, boolean skipLastEmptyLine) {
            Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
            return this.tokenize(chars, 0, chars.length, includeSeparators, skipLastEmptyLine);
        }

        public static /* synthetic */ String[] tokenize$default(Companion companion, char[] cArray, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return companion.tokenize(cArray, bl, bl2);
        }

        @JvmOverloads
        @NotNull
        public final String[] tokenize(@NotNull char[] chars, int startOffset, int endOffset, boolean includeSeparators, boolean skipLastEmptyLine) {
            Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
            return this.tokenize(new CharArrayCharSequence(chars, startOffset, endOffset), includeSeparators, skipLastEmptyLine);
        }

        public static /* synthetic */ String[] tokenize$default(Companion companion, char[] cArray, int n, int n2, boolean bl, boolean bl2, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                bl2 = true;
            }
            return companion.tokenize(cArray, n, n2, bl, bl2);
        }

        private final boolean stringEndsWithSeparator(LineTokenizer tokenizer) {
            return tokenizer.getLineSeparatorLength() > 0;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String[] tokenize(@Nullable CharSequence chars, boolean includeSeparators) {
            return com.intellij.openapi.util.text.LineTokenizer$Companion.tokenize$default(this, chars, includeSeparators, false, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final List<String> tokenizeIntoList(@Nullable CharSequence chars, boolean includeSeparators) {
            return com.intellij.openapi.util.text.LineTokenizer$Companion.tokenizeIntoList$default(this, chars, includeSeparators, false, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String[] tokenize(@NotNull char[] chars, boolean includeSeparators) {
            Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
            return com.intellij.openapi.util.text.LineTokenizer$Companion.tokenize$default(this, chars, includeSeparators, false, 4, null);
        }

        @JvmOverloads
        @NotNull
        public final String[] tokenize(@NotNull char[] chars, int startOffset, int endOffset, boolean includeSeparators) {
            Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
            return com.intellij.openapi.util.text.LineTokenizer$Companion.tokenize$default(this, chars, startOffset, endOffset, includeSeparators, false, 16, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

