/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.text.StringUtil;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Version
implements Serializable,
Comparable<Version> {
    public final int major;
    public final int minor;
    public final int bugfix;

    public Version(int major, int minor, int bugfix) {
        this.major = major;
        this.minor = minor;
        this.bugfix = bugfix;
    }

    @Nullable
    public static Version parseVersion(@NotNull String versionString) {
        int patch;
        int minor;
        String[] versions;
        String version;
        int major;
        if (versionString == null) {
            Version.$$$reportNull$$$0(0);
        }
        if ((major = Version.parseNumber(version = (versions = versionString.split("\\."))[0], -1)) < 0) {
            return null;
        }
        int n = minor = versions.length > 1 ? Version.parseNumber(versions[1], -1) : 0;
        if (minor < 0) {
            return new Version(major, 0, 0);
        }
        int n2 = patch = versions.length > 2 ? Version.parseNumber(versions[2], -1) : 0;
        if (patch < 0) {
            return new Version(major, minor, 0);
        }
        return new Version(major, minor, patch);
    }

    private static int parseNumber(String num, int def2) {
        return StringUtil.parseInt(num.replaceFirst("(\\d+).*", "$1"), def2);
    }

    @Override
    public int compareTo(@NotNull Version version) {
        if (version == null) {
            Version.$$$reportNull$$$0(1);
        }
        return this.compareTo(version.major, version.minor, version.bugfix);
    }

    public int compareTo(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix) {
        int result2 = Version.doCompare(this.major, major);
        if (result2 != 0) {
            return result2;
        }
        result2 = Version.doCompare(this.minor, minor);
        if (result2 != 0) {
            return result2;
        }
        return Version.doCompare(this.bugfix, bugfix);
    }

    private static int doCompare(Integer l, Integer r) {
        if (l == null || r == null) {
            return 0;
        }
        return l - r;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.bugfix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.bugfix != version.bugfix) {
            return false;
        }
        if (this.major != version.major) {
            return false;
        }
        return this.minor == version.minor;
    }

    public int hashCode() {
        int result2 = this.major;
        result2 = 31 * result2 + this.minor;
        result2 = 31 * result2 + this.bugfix;
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/Version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/Version";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toCompactString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

