/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.eventLog.util.StringUtil;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRegexpAwareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRegexpValidationRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegexpValidationRule.kt\ncom/intellij/internal/statistic/eventLog/validator/rules/impl/RegexpValidationRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1549#2:56\n1620#2,3:57\n*S KotlinDebug\n*F\n+ 1 RegexpValidationRule.kt\ncom/intellij/internal/statistic/eventLog/validator/rules/impl/RegexpValidationRule\n*L\n48#1:56\n48#1:57,3\n*E\n"})
public final class RegexpValidationRule
extends PerformanceCareRule
implements FUSRegexpAwareRule {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final String regexp;
    @NotNull
    private final Lazy myPattern$delegate;
    @NotNull
    private static final List<String> ESCAPE_FROM;
    @NotNull
    private static final List<String> ESCAPE_TO;

    public RegexpValidationRule(@Nullable String regexp) {
        this.regexp = regexp;
        this.myPattern$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pattern>(this){
            final /* synthetic */ RegexpValidationRule this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Pattern invoke() {
                return RegexpValidationRule.access$computePattern(this.this$0, RegexpValidationRule.access$getRegexp$p(this.this$0));
            }
        }));
    }

    private final Pattern getMyPattern() {
        Lazy lazy = this.myPattern$delegate;
        return (Pattern)lazy.getValue();
    }

    @Override
    @NotNull
    protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Pattern pattern = this.getMyPattern();
        if (pattern == null) {
            return ValidationResultType.INCORRECT_RULE;
        }
        Pattern pattern2 = pattern;
        String escaped = StatisticsEventEscaper.escapeEventIdOrFieldValue(data2);
        if (pattern2.matcher(escaped).matches()) {
            return ValidationResultType.ACCEPTED;
        }
        String legacyData = StatisticsEventEscaper.cleanupForLegacyRulesIfNeeded(escaped);
        return legacyData != null && pattern2.matcher(legacyData).matches() ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
    }

    @Override
    @NotNull
    public String asRegexp() {
        String string = this.regexp;
        if (string == null) {
            string = "<invalid>";
        }
        return string;
    }

    @NotNull
    public String toString() {
        return "RegexpValidationRule: myRegexp=" + this.asRegexp();
    }

    private final Pattern computePattern(String regexp) {
        Pattern pattern;
        if (regexp == null) {
            return null;
        }
        try {
            pattern = Pattern.compile(regexp);
        }
        catch (Exception ignored) {
            pattern = null;
        }
        return pattern;
    }

    @JvmStatic
    @NotNull
    public static final String escapeText(@NotNull String text2) {
        return Companion.escapeText(text2);
    }

    public static final /* synthetic */ Pattern access$computePattern(RegexpValidationRule $this, String regexp) {
        return $this.computePattern(regexp);
    }

    public static final /* synthetic */ String access$getRegexp$p(RegexpValidationRule $this) {
        return $this.regexp;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new String[]{"\\", "[", "]", "{", "}", "(", ")", "-", "^", "*", "+", "?", ".", "|", "$"};
        ESCAPE_FROM = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$map$iv = ESCAPE_FROM;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add('\\' + (String)it);
        }
        ESCAPE_TO = (List)var3_3;
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String escapeText(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            String string = StringUtil.replace(text2, ESCAPE_FROM, ESCAPE_TO);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(text, ESCAPE_FROM, ESCAPE_TO)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

