/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.beans;

import com.intellij.internal.statistic.eventLog.validator.rules.impl.EnumValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RegexpValidationRule;
import com.intellij.internal.statistic.eventLog.validator.storage.GlobalRulesHolder;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventGroupContextData {
    public static final EventGroupContextData EMPTY = new EventGroupContextData(null, null, null);
    @Nullable
    private final Map<String, ? extends Set<String>> myEnums;
    @Nullable
    private final Map<String, String> myRegexps;
    @Nullable
    GlobalRulesHolder myGlobalRulesHolder;

    public EventGroupContextData(@Nullable Map<String, ? extends Set<String>> enums, @Nullable Map<String, String> regexps, @Nullable GlobalRulesHolder globalRulesHolder) {
        this.myEnums = enums;
        this.myRegexps = regexps;
        this.myGlobalRulesHolder = globalRulesHolder;
    }

    @NotNull
    public EnumValidationRule getEnumValidationRule(@NotNull String enumRef) {
        EnumValidationRule globalEnum;
        Set<String> values;
        if (this.myEnums != null && (values = this.myEnums.get(enumRef)) != null) {
            return new EnumValidationRule(values);
        }
        if (this.myGlobalRulesHolder != null && (globalEnum = this.myGlobalRulesHolder.getEnumValidationRules(enumRef)) != null) {
            return globalEnum;
        }
        return new EnumValidationRule(null);
    }

    @NotNull
    public RegexpValidationRule getRegexpValidationRule(@NotNull String regexpRef) {
        RegexpValidationRule globalRegexp;
        String regexp;
        if (this.myRegexps != null && (regexp = this.myRegexps.get(regexpRef)) != null) {
            return new RegexpValidationRule(regexp);
        }
        if (this.myGlobalRulesHolder != null && (globalRegexp = this.myGlobalRulesHolder.getRegexpValidationRules(regexpRef)) != null) {
            return globalRegexp;
        }
        return new RegexpValidationRule(null);
    }
}

